/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es6.dao.index;

import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.es6.dao.query.parser.Expression;
import com.netflix.conductor.es6.dao.query.parser.internal.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;

abstract class ElasticSearchBaseDAO
implements IndexDAO {
    String indexPrefix;

    ElasticSearchBaseDAO() {
    }

    String loadTypeMappingSource(String path) throws IOException {
        return this.applyIndexPrefixToTemplate(IOUtils.toString((InputStream)ElasticSearchBaseDAO.class.getResourceAsStream(path)));
    }

    private String applyIndexPrefixToTemplate(String text) {
        String pattern = "\"template\": \"\\*(.*)\\*\"";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(0).replaceFirst(Pattern.quote(m.group(1)), this.indexPrefix + "_" + m.group(1)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    BoolQueryBuilder boolQueryBuilder(String expression, String queryString) throws ParserException {
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            Expression exp = Expression.fromString(expression);
            queryBuilder = exp.getFilterBuilder();
        }
        BoolQueryBuilder filterQuery = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder);
        QueryStringQueryBuilder stringQuery = QueryBuilders.queryStringQuery((String)queryString);
        return QueryBuilders.boolQuery().must((QueryBuilder)stringQuery).must((QueryBuilder)filterQuery);
    }

    protected String getIndexName(String documentType) {
        return this.indexPrefix + "_" + documentType;
    }
}

