/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es6.dao.query.parser.internal;

import com.netflix.conductor.es6.dao.query.parser.internal.AbstractNode;
import com.netflix.conductor.es6.dao.query.parser.internal.ParserException;
import java.io.InputStream;

public class ConstValue
extends AbstractNode {
    private static final String QUOTE = "\"";
    private Object value;
    private SystemConsts sysConsts;

    public ConstValue(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        byte[] peeked = this.peek(4);
        String sp = new String(peeked).trim();
        if (peeked[0] == 34 || peeked[0] == 39) {
            this.value = this.readString(this.is);
        } else if (sp.toLowerCase().startsWith("not")) {
            this.value = SystemConsts.NOT_NULL.value();
            this.sysConsts = SystemConsts.NOT_NULL;
            this.read(SystemConsts.NOT_NULL.value().length());
        } else if (sp.equalsIgnoreCase(SystemConsts.NULL.value())) {
            this.value = SystemConsts.NULL.value();
            this.sysConsts = SystemConsts.NULL;
            this.read(SystemConsts.NULL.value().length());
        } else {
            this.value = this.readNumber(this.is);
        }
    }

    private String readNumber(InputStream is) throws Exception {
        StringBuilder sb = new StringBuilder();
        while (is.available() > 0) {
            is.mark(1);
            char c = (char)is.read();
            if (!this.isNumeric(c)) {
                is.reset();
                break;
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }

    private String readString(InputStream is) throws Exception {
        char delim = (char)this.read(1)[0];
        StringBuilder sb = new StringBuilder();
        boolean valid = false;
        while (is.available() > 0) {
            char c = (char)is.read();
            if (c == delim) {
                valid = true;
                break;
            }
            if (c == '\\') {
                c = (char)is.read();
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (!valid) {
            throw new ParserException("String constant is not quoted with <" + delim + "> : " + sb.toString());
        }
        return QUOTE + sb.toString() + QUOTE;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    public String getUnquotedValue() {
        String result = this.toString();
        if (result.length() >= 2 && result.startsWith(QUOTE) && result.endsWith(QUOTE)) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    public boolean isSysConstant() {
        return this.sysConsts != null;
    }

    public SystemConsts getSysConstant() {
        return this.sysConsts;
    }

    public static enum SystemConsts {
        NULL("null"),
        NOT_NULL("not null");

        private final String value;

        private SystemConsts(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

