/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es7.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.es7.config.ElasticSearchConditions;
import com.netflix.conductor.es7.config.ElasticSearchProperties;
import com.netflix.conductor.es7.dao.index.ElasticSearchRestDAOV7;
import java.net.URL;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ElasticSearchProperties.class})
@Conditional(value={ElasticSearchConditions.ElasticSearchV7Enabled.class})
public class ElasticSearchV7Configuration {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchV7Configuration.class);

    @Bean
    public RestClient restClient(ElasticSearchProperties properties) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.convertToHttpHosts(properties.toURLs()));
        if (properties.getRestClientConnectionRequestTimeout() > 0) {
            restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(properties.getRestClientConnectionRequestTimeout()));
        }
        return restClientBuilder.build();
    }

    @Bean
    public RestClientBuilder restClientBuilder(ElasticSearchProperties properties) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.convertToHttpHosts(properties.toURLs()));
        if (properties.getUsername() != null && properties.getPassword() != null) {
            log.info("Configure ElasticSearch with BASIC authentication. User:{}", (Object)properties.getUsername());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(properties.getUsername(), properties.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchV7Configuration.lambda$restClientBuilder$1((CredentialsProvider)credentialsProvider, arg_0));
        } else {
            log.info("Configure ElasticSearch with no authentication.");
        }
        return builder;
    }

    @Primary
    @Bean
    public IndexDAO es7IndexDAO(RestClientBuilder restClientBuilder, @Qualifier(value="es7RetryTemplate") RetryTemplate retryTemplate, ElasticSearchProperties properties, ObjectMapper objectMapper) {
        String url = properties.getUrl();
        return new ElasticSearchRestDAOV7(restClientBuilder, retryTemplate, properties, objectMapper);
    }

    @Bean
    public RetryTemplate es7RetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(1000L);
        retryTemplate.setBackOffPolicy(fixedBackOffPolicy);
        return retryTemplate;
    }

    private HttpHost[] convertToHttpHosts(List<URL> hosts) {
        return (HttpHost[])hosts.stream().map(host -> new HttpHost(host.getHost(), host.getPort(), host.getProtocol())).toArray(HttpHost[]::new);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restClientBuilder$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

