/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.netflix.conductor.client.grpc.ClientBase;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.grpc.EventServiceGrpc;
import com.netflix.conductor.grpc.EventServicePb;
import com.netflix.conductor.grpc.ProtoMapper;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class EventClient
extends ClientBase {
    private final EventServiceGrpc.EventServiceBlockingStub stub;

    public EventClient(String address, int port) {
        super(address, port);
        this.stub = EventServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public EventClient(ManagedChannelBuilder<?> builder) {
        super(builder);
        this.stub = EventServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void registerEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler, (Object)"Event handler definition cannot be null");
        this.stub.addEventHandler(EventServicePb.AddEventHandlerRequest.newBuilder().setHandler(protoMapper.toProto(eventHandler)).build());
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler, (Object)"Event handler definition cannot be null");
        this.stub.updateEventHandler(EventServicePb.UpdateEventHandlerRequest.newBuilder().setHandler(protoMapper.toProto(eventHandler)).build());
    }

    public Iterator<EventHandler> getEventHandlers(String event, boolean activeOnly) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)event), (Object)"Event cannot be blank");
        EventServicePb.GetEventHandlersForEventRequest.Builder request = EventServicePb.GetEventHandlersForEventRequest.newBuilder().setEvent(event).setActiveOnly(activeOnly);
        Iterator it = this.stub.getEventHandlersForEvent(request.build());
        return Iterators.transform((Iterator)it, arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0));
    }

    public void unregisterEventHandler(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"Name cannot be blank");
        this.stub.removeEventHandler(EventServicePb.RemoveEventHandlerRequest.newBuilder().setName(name).build());
    }
}

