/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.netflix.conductor.client.grpc.ClientBase;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.grpc.ProtoMapper;
import com.netflix.conductor.grpc.SearchPb;
import com.netflix.conductor.grpc.TaskServiceGrpc;
import com.netflix.conductor.grpc.TaskServicePb;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class TaskClient
extends ClientBase {
    private final TaskServiceGrpc.TaskServiceBlockingStub stub;

    public TaskClient(String address, int port) {
        super(address, port);
        this.stub = TaskServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public TaskClient(ManagedChannelBuilder<?> builder) {
        super(builder);
        this.stub = TaskServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public Task pollTask(String taskType, String workerId, String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domain), (Object)"Domain cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workerId), (Object)"Worker id cannot be blank");
        TaskServicePb.PollResponse response = this.stub.poll(TaskServicePb.PollRequest.newBuilder().setTaskType(taskType).setWorkerId(workerId).setDomain(domain).build());
        return protoMapper.fromProto(response.getTask());
    }

    public List<Task> batchPollTasksByTaskType(String taskType, String workerId, int count, int timeoutInMillisecond) {
        return Lists.newArrayList(this.batchPollTasksByTaskTypeAsync(taskType, workerId, count, timeoutInMillisecond));
    }

    public Iterator<Task> batchPollTasksByTaskTypeAsync(String taskType, String workerId, int count, int timeoutInMillisecond) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskType), (Object)"Task type cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workerId), (Object)"Worker id cannot be blank");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than 0");
        Iterator it = this.stub.batchPoll(TaskServicePb.BatchPollRequest.newBuilder().setTaskType(taskType).setWorkerId(workerId).setCount(count).setTimeout(timeoutInMillisecond).build());
        return Iterators.transform((Iterator)it, arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0));
    }

    public void updateTask(TaskResult taskResult) {
        Preconditions.checkNotNull((Object)taskResult, (Object)"Task result cannot be null");
        this.stub.updateTask(TaskServicePb.UpdateTaskRequest.newBuilder().setResult(protoMapper.toProto(taskResult)).build());
    }

    public void logMessageForTask(String taskId, String logMessage) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskId), (Object)"Task id cannot be blank");
        this.stub.addLog(TaskServicePb.AddLogRequest.newBuilder().setTaskId(taskId).setLog(logMessage).build());
    }

    public List<TaskExecLog> getTaskLogs(String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskId), (Object)"Task id cannot be blank");
        return this.stub.getTaskLogs(TaskServicePb.GetTaskLogsRequest.newBuilder().setTaskId(taskId).build()).getLogsList().stream().map(arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0)).collect(Collectors.toList());
    }

    public Task getTaskDetails(String taskId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskId), (Object)"Task id cannot be blank");
        return protoMapper.fromProto(this.stub.getTask(TaskServicePb.GetTaskRequest.newBuilder().setTaskId(taskId).build()).getTask());
    }

    public int getQueueSizeForTask(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskType), (Object)"Task type cannot be blank");
        TaskServicePb.QueueSizesResponse sizes = this.stub.getQueueSizesForTasks(TaskServicePb.QueueSizesRequest.newBuilder().addTaskTypes(taskType).build());
        return sizes.getQueueForTaskOrDefault(taskType, 0);
    }

    public SearchResult<TaskSummary> search(String query) {
        return this.search(null, null, null, null, query);
    }

    public SearchResult<Task> searchV2(String query) {
        return this.searchV2(null, null, null, null, query);
    }

    public SearchResult<TaskSummary> search(@Nullable Integer start, @Nullable Integer size, @Nullable String sort, @Nullable String freeText, @Nullable String query) {
        SearchPb.Request searchRequest = this.createSearchRequest(start, size, sort, freeText, query);
        TaskServicePb.TaskSummarySearchResult result = this.stub.search(searchRequest);
        return new SearchResult(result.getTotalHits(), result.getResultsList().stream().map(arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0)).collect(Collectors.toList()));
    }

    public SearchResult<Task> searchV2(@Nullable Integer start, @Nullable Integer size, @Nullable String sort, @Nullable String freeText, @Nullable String query) {
        SearchPb.Request searchRequest = this.createSearchRequest(start, size, sort, freeText, query);
        TaskServicePb.TaskSearchResult result = this.stub.searchV2(searchRequest);
        return new SearchResult(result.getTotalHits(), result.getResultsList().stream().map(arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0)).collect(Collectors.toList()));
    }
}

