/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.grpc;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.grpc.ClientBase;
import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.grpc.ProtoMapper;
import com.netflix.conductor.grpc.SearchPb;
import com.netflix.conductor.grpc.WorkflowServiceGrpc;
import com.netflix.conductor.grpc.WorkflowServicePb;
import com.netflix.conductor.proto.WorkflowPb;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class WorkflowClient
extends ClientBase {
    private final WorkflowServiceGrpc.WorkflowServiceBlockingStub stub;

    public WorkflowClient(String address, int port) {
        super(address, port);
        this.stub = WorkflowServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public WorkflowClient(ManagedChannelBuilder<?> builder) {
        super(builder);
        this.stub = WorkflowServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public String startWorkflow(StartWorkflowRequest startWorkflowRequest) {
        Preconditions.checkNotNull((Object)startWorkflowRequest, (Object)"StartWorkflowRequest cannot be null");
        return this.stub.startWorkflow(protoMapper.toProto(startWorkflowRequest)).getWorkflowId();
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        WorkflowPb.Workflow workflow = this.stub.getWorkflowStatus(WorkflowServicePb.GetWorkflowStatusRequest.newBuilder().setWorkflowId(workflowId).setIncludeTasks(includeTasks).build());
        return protoMapper.fromProto(workflow);
    }

    public List<Workflow> getWorkflows(String name, String correlationId, boolean includeClosed, boolean includeTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)correlationId), (Object)"correlationId cannot be blank");
        WorkflowServicePb.GetWorkflowsResponse workflows = this.stub.getWorkflows(WorkflowServicePb.GetWorkflowsRequest.newBuilder().setName(name).addCorrelationId(correlationId).setIncludeClosed(includeClosed).setIncludeTasks(includeTasks).build());
        if (!workflows.containsWorkflowsById(correlationId)) {
            return Collections.emptyList();
        }
        return workflows.getWorkflowsByIdOrThrow(correlationId).getWorkflowsList().stream().map(arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0)).collect(Collectors.toList());
    }

    public void deleteWorkflow(String workflowId, boolean archiveWorkflow) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"Workflow id cannot be blank");
        this.stub.removeWorkflow(WorkflowServicePb.RemoveWorkflowRequest.newBuilder().setWorkflodId(workflowId).setArchiveWorkflow(archiveWorkflow).build());
    }

    public List<String> getRunningWorkflow(String workflowName, @Nullable Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowName), (Object)"Workflow name cannot be blank");
        WorkflowServicePb.GetRunningWorkflowsResponse workflows = this.stub.getRunningWorkflows(WorkflowServicePb.GetRunningWorkflowsRequest.newBuilder().setName(workflowName).setVersion(version == null ? 1 : version).build());
        return workflows.getWorkflowIdsList();
    }

    public List<String> getWorkflowsByTimePeriod(String workflowName, int version, Long startTime, Long endTime) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowName), (Object)"Workflow name cannot be blank");
        Preconditions.checkNotNull((Object)startTime, (Object)"Start time cannot be null");
        Preconditions.checkNotNull((Object)endTime, (Object)"End time cannot be null");
        return null;
    }

    public void runDecider(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.decideWorkflow(WorkflowServicePb.DecideWorkflowRequest.newBuilder().setWorkflowId(workflowId).build());
    }

    public void pauseWorkflow(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.pauseWorkflow(WorkflowServicePb.PauseWorkflowRequest.newBuilder().setWorkflowId(workflowId).build());
    }

    public void resumeWorkflow(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.resumeWorkflow(WorkflowServicePb.ResumeWorkflowRequest.newBuilder().setWorkflowId(workflowId).build());
    }

    public void skipTaskFromWorkflow(String workflowId, String taskReferenceName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskReferenceName), (Object)"Task reference name cannot be blank");
        this.stub.skipTaskFromWorkflow(WorkflowServicePb.SkipTaskRequest.newBuilder().setWorkflowId(workflowId).setTaskReferenceName(taskReferenceName).build());
    }

    public String rerunWorkflow(RerunWorkflowRequest rerunWorkflowRequest) {
        Preconditions.checkNotNull((Object)rerunWorkflowRequest, (Object)"RerunWorkflowRequest cannot be null");
        return this.stub.rerunWorkflow(protoMapper.toProto(rerunWorkflowRequest)).getWorkflowId();
    }

    public void restart(String workflowId, boolean useLatestDefinitions) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.restartWorkflow(WorkflowServicePb.RestartWorkflowRequest.newBuilder().setWorkflowId(workflowId).setUseLatestDefinitions(useLatestDefinitions).build());
    }

    public void retryLastFailedTask(String workflowId, boolean resumeSubworkflowTasks) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.retryWorkflow(WorkflowServicePb.RetryWorkflowRequest.newBuilder().setWorkflowId(workflowId).setResumeSubworkflowTasks(resumeSubworkflowTasks).build());
    }

    public void resetCallbacksForInProgressTasks(String workflowId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.resetWorkflowCallbacks(WorkflowServicePb.ResetWorkflowCallbacksRequest.newBuilder().setWorkflowId(workflowId).build());
    }

    public void terminateWorkflow(String workflowId, String reason) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)workflowId), (Object)"workflow id cannot be blank");
        this.stub.terminateWorkflow(WorkflowServicePb.TerminateWorkflowRequest.newBuilder().setWorkflowId(workflowId).setReason(reason).build());
    }

    public SearchResult<WorkflowSummary> search(String query) {
        return this.search(null, null, null, null, query);
    }

    public SearchResult<Workflow> searchV2(String query) {
        return this.searchV2(null, null, null, null, query);
    }

    public SearchResult<WorkflowSummary> search(@Nullable Integer start, @Nullable Integer size, @Nullable String sort, @Nullable String freeText, @Nullable String query) {
        SearchPb.Request searchRequest = this.createSearchRequest(start, size, sort, freeText, query);
        WorkflowServicePb.WorkflowSummarySearchResult result = this.stub.search(searchRequest);
        return new SearchResult(result.getTotalHits(), result.getResultsList().stream().map(arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0)).collect(Collectors.toList()));
    }

    public SearchResult<Workflow> searchV2(@Nullable Integer start, @Nullable Integer size, @Nullable String sort, @Nullable String freeText, @Nullable String query) {
        SearchPb.Request searchRequest = this.createSearchRequest(start, size, sort, freeText, query);
        WorkflowServicePb.WorkflowSearchResult result = this.stub.searchV2(searchRequest);
        return new SearchResult(result.getTotalHits(), result.getResultsList().stream().map(arg_0 -> ((ProtoMapper)protoMapper).fromProto(arg_0)).collect(Collectors.toList()));
    }
}

