/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server.service;

import com.google.protobuf.MessageLite;
import com.google.rpc.DebugInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class GRPCHelper {
    private final Logger logger;
    private static final Metadata.Key<DebugInfo> STATUS_DETAILS_KEY = Metadata.Key.of((String)"grpc-status-details-bin", (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)DebugInfo.getDefaultInstance()));

    public GRPCHelper(Logger log) {
        this.logger = log;
    }

    private StatusException throwableToStatusException(Throwable t) {
        String[] frames = ExceptionUtils.getStackFrames((Throwable)t);
        Metadata metadata = new Metadata();
        metadata.put(STATUS_DETAILS_KEY, (Object)DebugInfo.newBuilder().addAllStackEntries(Arrays.asList(frames)).setDetail(ExceptionUtils.getMessage((Throwable)t)).build());
        return Status.INTERNAL.withDescription(t.getMessage()).withCause(t).asException(metadata);
    }

    void onError(StreamObserver<?> response, Throwable t) {
        this.logger.error("internal exception during GRPC request", t);
        response.onError((Throwable)this.throwableToStatusException(t));
    }

    String optional(@Nonnull String str) {
        return str.isEmpty() ? null : str;
    }

    String optionalOr(@Nonnull String str, String defaults) {
        return str.isEmpty() ? defaults : str;
    }

    Integer optional(@Nonnull Integer i) {
        return i == 0 ? null : i;
    }

    Integer optionalOr(@Nonnull Integer i, int defaults) {
        return i == 0 ? defaults : i;
    }
}

