/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server.service;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.grpc.ProtoMapper;
import com.netflix.conductor.grpc.SearchPb;
import com.netflix.conductor.grpc.TaskServiceGrpc;
import com.netflix.conductor.grpc.TaskServicePb;
import com.netflix.conductor.grpc.server.service.GRPCHelper;
import com.netflix.conductor.proto.TaskPb;
import com.netflix.conductor.service.ExecutionService;
import com.netflix.conductor.service.TaskService;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="grpcTaskService")
public class TaskServiceImpl
extends TaskServiceGrpc.TaskServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final ProtoMapper PROTO_MAPPER = ProtoMapper.INSTANCE;
    private static final GRPCHelper GRPC_HELPER = new GRPCHelper(LOGGER);
    private static final int POLL_TIMEOUT_MS = 100;
    private static final int MAX_POLL_TIMEOUT_MS = 5000;
    private final TaskService taskService;
    private final int maxSearchSize;
    private final ExecutionService executionService;

    public TaskServiceImpl(ExecutionService executionService, TaskService taskService, @Value(value="${workflow.max.search.size:5000}") int maxSearchSize) {
        this.executionService = executionService;
        this.taskService = taskService;
        this.maxSearchSize = maxSearchSize;
    }

    public void poll(TaskServicePb.PollRequest req, StreamObserver<TaskServicePb.PollResponse> response) {
        try {
            List tasks = this.executionService.poll(req.getTaskType(), req.getWorkerId(), GRPC_HELPER.optional(req.getDomain()), 1, 100);
            if (!tasks.isEmpty()) {
                TaskPb.Task t = PROTO_MAPPER.toProto((Task)tasks.get(0));
                response.onNext((Object)TaskServicePb.PollResponse.newBuilder().setTask(t).build());
            }
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void batchPoll(TaskServicePb.BatchPollRequest req, StreamObserver<TaskPb.Task> response) {
        int count = GRPC_HELPER.optionalOr(req.getCount(), 1);
        int timeout = GRPC_HELPER.optionalOr(req.getTimeout(), 100);
        if (timeout > 5000) {
            response.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("longpoll timeout cannot be longer than 5000ms").asRuntimeException());
            return;
        }
        try {
            List polledTasks = this.taskService.batchPoll(req.getTaskType(), req.getWorkerId(), GRPC_HELPER.optional(req.getDomain()), Integer.valueOf(count), Integer.valueOf(timeout));
            LOGGER.info("polled tasks: " + polledTasks);
            polledTasks.stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0)).forEach(arg_0 -> response.onNext(arg_0));
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void updateTask(TaskServicePb.UpdateTaskRequest req, StreamObserver<TaskServicePb.UpdateTaskResponse> response) {
        try {
            TaskResult task = PROTO_MAPPER.fromProto(req.getResult());
            this.taskService.updateTask(task);
            response.onNext((Object)TaskServicePb.UpdateTaskResponse.newBuilder().setTaskId(task.getTaskId()).build());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void addLog(TaskServicePb.AddLogRequest req, StreamObserver<TaskServicePb.AddLogResponse> response) {
        this.taskService.log(req.getTaskId(), req.getLog());
        response.onNext((Object)TaskServicePb.AddLogResponse.getDefaultInstance());
        response.onCompleted();
    }

    public void getTaskLogs(TaskServicePb.GetTaskLogsRequest req, StreamObserver<TaskServicePb.GetTaskLogsResponse> response) {
        List logs = this.taskService.getTaskLogs(req.getTaskId());
        response.onNext((Object)TaskServicePb.GetTaskLogsResponse.newBuilder().addAllLogs(logs.stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0))::iterator).build());
        response.onCompleted();
    }

    public void getTask(TaskServicePb.GetTaskRequest req, StreamObserver<TaskServicePb.GetTaskResponse> response) {
        try {
            Task task = this.taskService.getTask(req.getTaskId());
            if (task == null) {
                response.onError((Throwable)Status.NOT_FOUND.withDescription("No such task found by id=" + req.getTaskId()).asRuntimeException());
            } else {
                response.onNext((Object)TaskServicePb.GetTaskResponse.newBuilder().setTask(PROTO_MAPPER.toProto(task)).build());
                response.onCompleted();
            }
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void getQueueSizesForTasks(TaskServicePb.QueueSizesRequest req, StreamObserver<TaskServicePb.QueueSizesResponse> response) {
        Map sizes = this.taskService.getTaskQueueSizes((List)req.getTaskTypesList());
        response.onNext((Object)TaskServicePb.QueueSizesResponse.newBuilder().putAllQueueForTask(sizes).build());
        response.onCompleted();
    }

    public void getQueueInfo(TaskServicePb.QueueInfoRequest req, StreamObserver<TaskServicePb.QueueInfoResponse> response) {
        Map queueInfo = this.taskService.getAllQueueDetails();
        response.onNext((Object)TaskServicePb.QueueInfoResponse.newBuilder().putAllQueues(queueInfo).build());
        response.onCompleted();
    }

    public void getQueueAllInfo(TaskServicePb.QueueAllInfoRequest req, StreamObserver<TaskServicePb.QueueAllInfoResponse> response) {
        Map info = this.taskService.allVerbose();
        TaskServicePb.QueueAllInfoResponse.Builder queuesBuilder = TaskServicePb.QueueAllInfoResponse.newBuilder();
        for (Map.Entry queue : info.entrySet()) {
            String queueName = (String)queue.getKey();
            Map queueShards = (Map)queue.getValue();
            TaskServicePb.QueueAllInfoResponse.QueueInfo.Builder queueInfoBuilder = TaskServicePb.QueueAllInfoResponse.QueueInfo.newBuilder();
            for (Map.Entry shard : queueShards.entrySet()) {
                String shardName = (String)shard.getKey();
                Map shardInfo = (Map)shard.getValue();
                queueInfoBuilder.putShards(shardName, TaskServicePb.QueueAllInfoResponse.ShardInfo.newBuilder().setSize(((Long)shardInfo.get("size")).longValue()).setUacked(((Long)shardInfo.get("uacked")).longValue()).build());
            }
            queuesBuilder.putQueues(queueName, queueInfoBuilder.build());
        }
        response.onNext((Object)queuesBuilder.build());
        response.onCompleted();
    }

    public void search(SearchPb.Request req, StreamObserver<TaskServicePb.TaskSummarySearchResult> response) {
        int start = req.getStart();
        int size = GRPC_HELPER.optionalOr(req.getSize(), this.maxSearchSize);
        String sort = req.getSort();
        String freeText = GRPC_HELPER.optionalOr(req.getFreeText(), "*");
        String query = req.getQuery();
        if (size > this.maxSearchSize) {
            response.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Cannot return more than " + this.maxSearchSize + " results").asRuntimeException());
            return;
        }
        SearchResult searchResult = this.taskService.search(start, size, sort, freeText, query);
        response.onNext((Object)TaskServicePb.TaskSummarySearchResult.newBuilder().setTotalHits(searchResult.getTotalHits()).addAllResults(searchResult.getResults().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0))::iterator).build());
        response.onCompleted();
    }

    public void searchV2(SearchPb.Request req, StreamObserver<TaskServicePb.TaskSearchResult> response) {
        int start = req.getStart();
        int size = GRPC_HELPER.optionalOr(req.getSize(), this.maxSearchSize);
        String sort = req.getSort();
        String freeText = GRPC_HELPER.optionalOr(req.getFreeText(), "*");
        String query = req.getQuery();
        if (size > this.maxSearchSize) {
            response.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Cannot return more than " + this.maxSearchSize + " results").asRuntimeException());
            return;
        }
        SearchResult searchResult = this.taskService.searchV2(start, size, sort, freeText, query);
        response.onNext((Object)TaskServicePb.TaskSearchResult.newBuilder().setTotalHits(searchResult.getTotalHits()).addAllResults(searchResult.getResults().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0))::iterator).build());
        response.onCompleted();
    }
}

