/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc.server.service;

import com.netflix.conductor.common.metadata.workflow.SkipTaskRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.core.exception.NotFoundException;
import com.netflix.conductor.grpc.ProtoMapper;
import com.netflix.conductor.grpc.SearchPb;
import com.netflix.conductor.grpc.WorkflowServiceGrpc;
import com.netflix.conductor.grpc.WorkflowServicePb;
import com.netflix.conductor.grpc.server.service.GRPCHelper;
import com.netflix.conductor.grpc.server.service.TaskServiceImpl;
import com.netflix.conductor.proto.RerunWorkflowRequestPb;
import com.netflix.conductor.proto.StartWorkflowRequestPb;
import com.netflix.conductor.proto.WorkflowPb;
import com.netflix.conductor.service.WorkflowService;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="grpcWorkflowService")
public class WorkflowServiceImpl
extends WorkflowServiceGrpc.WorkflowServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final ProtoMapper PROTO_MAPPER = ProtoMapper.INSTANCE;
    private static final GRPCHelper GRPC_HELPER = new GRPCHelper(LOGGER);
    private final WorkflowService workflowService;
    private final int maxSearchSize;

    public WorkflowServiceImpl(WorkflowService workflowService, @Value(value="${workflow.max.search.size:5000}") int maxSearchSize) {
        this.workflowService = workflowService;
        this.maxSearchSize = maxSearchSize;
    }

    public void startWorkflow(StartWorkflowRequestPb.StartWorkflowRequest pbRequest, StreamObserver<WorkflowServicePb.StartWorkflowResponse> response) {
        StartWorkflowRequest request = PROTO_MAPPER.fromProto(pbRequest);
        try {
            String id = this.workflowService.startWorkflow(pbRequest.getName(), GRPC_HELPER.optional(request.getVersion()), request.getCorrelationId(), request.getPriority(), request.getInput(), request.getExternalInputPayloadStoragePath(), request.getTaskToDomain(), request.getWorkflowDef());
            response.onNext((Object)WorkflowServicePb.StartWorkflowResponse.newBuilder().setWorkflowId(id).build());
            response.onCompleted();
        }
        catch (NotFoundException nfe) {
            response.onError((Throwable)Status.NOT_FOUND.withDescription("No such workflow found by name=" + request.getName()).asRuntimeException());
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void getWorkflows(WorkflowServicePb.GetWorkflowsRequest req, StreamObserver<WorkflowServicePb.GetWorkflowsResponse> response) {
        String name = req.getName();
        boolean includeClosed = req.getIncludeClosed();
        boolean includeTasks = req.getIncludeTasks();
        WorkflowServicePb.GetWorkflowsResponse.Builder builder = WorkflowServicePb.GetWorkflowsResponse.newBuilder();
        for (String correlationId : req.getCorrelationIdList()) {
            List workflows = this.workflowService.getWorkflows(name, correlationId, includeClosed, includeTasks);
            builder.putWorkflowsById(correlationId, WorkflowServicePb.GetWorkflowsResponse.Workflows.newBuilder().addAllWorkflows(workflows.stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0))::iterator).build());
        }
        response.onNext((Object)builder.build());
        response.onCompleted();
    }

    public void getWorkflowStatus(WorkflowServicePb.GetWorkflowStatusRequest req, StreamObserver<WorkflowPb.Workflow> response) {
        try {
            Workflow workflow = this.workflowService.getExecutionStatus(req.getWorkflowId(), req.getIncludeTasks());
            response.onNext((Object)PROTO_MAPPER.toProto(workflow));
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void removeWorkflow(WorkflowServicePb.RemoveWorkflowRequest req, StreamObserver<WorkflowServicePb.RemoveWorkflowResponse> response) {
        try {
            this.workflowService.deleteWorkflow(req.getWorkflodId(), req.getArchiveWorkflow());
            response.onNext((Object)WorkflowServicePb.RemoveWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void getRunningWorkflows(WorkflowServicePb.GetRunningWorkflowsRequest req, StreamObserver<WorkflowServicePb.GetRunningWorkflowsResponse> response) {
        try {
            List workflowIds = this.workflowService.getRunningWorkflows(req.getName(), Integer.valueOf(req.getVersion()), Long.valueOf(req.getStartTime()), Long.valueOf(req.getEndTime()));
            response.onNext((Object)WorkflowServicePb.GetRunningWorkflowsResponse.newBuilder().addAllWorkflowIds((Iterable)workflowIds).build());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void decideWorkflow(WorkflowServicePb.DecideWorkflowRequest req, StreamObserver<WorkflowServicePb.DecideWorkflowResponse> response) {
        try {
            this.workflowService.decideWorkflow(req.getWorkflowId());
            response.onNext((Object)WorkflowServicePb.DecideWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void pauseWorkflow(WorkflowServicePb.PauseWorkflowRequest req, StreamObserver<WorkflowServicePb.PauseWorkflowResponse> response) {
        try {
            this.workflowService.pauseWorkflow(req.getWorkflowId());
            response.onNext((Object)WorkflowServicePb.PauseWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void resumeWorkflow(WorkflowServicePb.ResumeWorkflowRequest req, StreamObserver<WorkflowServicePb.ResumeWorkflowResponse> response) {
        try {
            this.workflowService.resumeWorkflow(req.getWorkflowId());
            response.onNext((Object)WorkflowServicePb.ResumeWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void skipTaskFromWorkflow(WorkflowServicePb.SkipTaskRequest req, StreamObserver<WorkflowServicePb.SkipTaskResponse> response) {
        try {
            SkipTaskRequest skipTask = PROTO_MAPPER.fromProto(req.getRequest());
            this.workflowService.skipTaskFromWorkflow(req.getWorkflowId(), req.getTaskReferenceName(), skipTask);
            response.onNext((Object)WorkflowServicePb.SkipTaskResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void rerunWorkflow(RerunWorkflowRequestPb.RerunWorkflowRequest req, StreamObserver<WorkflowServicePb.RerunWorkflowResponse> response) {
        try {
            String id = this.workflowService.rerunWorkflow(req.getReRunFromWorkflowId(), PROTO_MAPPER.fromProto(req));
            response.onNext((Object)WorkflowServicePb.RerunWorkflowResponse.newBuilder().setWorkflowId(id).build());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void restartWorkflow(WorkflowServicePb.RestartWorkflowRequest req, StreamObserver<WorkflowServicePb.RestartWorkflowResponse> response) {
        try {
            this.workflowService.restartWorkflow(req.getWorkflowId(), req.getUseLatestDefinitions());
            response.onNext((Object)WorkflowServicePb.RestartWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void retryWorkflow(WorkflowServicePb.RetryWorkflowRequest req, StreamObserver<WorkflowServicePb.RetryWorkflowResponse> response) {
        try {
            this.workflowService.retryWorkflow(req.getWorkflowId(), req.getResumeSubworkflowTasks());
            response.onNext((Object)WorkflowServicePb.RetryWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void resetWorkflowCallbacks(WorkflowServicePb.ResetWorkflowCallbacksRequest req, StreamObserver<WorkflowServicePb.ResetWorkflowCallbacksResponse> response) {
        try {
            this.workflowService.resetWorkflow(req.getWorkflowId());
            response.onNext((Object)WorkflowServicePb.ResetWorkflowCallbacksResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    public void terminateWorkflow(WorkflowServicePb.TerminateWorkflowRequest req, StreamObserver<WorkflowServicePb.TerminateWorkflowResponse> response) {
        try {
            this.workflowService.terminateWorkflow(req.getWorkflowId(), req.getReason());
            response.onNext((Object)WorkflowServicePb.TerminateWorkflowResponse.getDefaultInstance());
            response.onCompleted();
        }
        catch (Exception e) {
            GRPC_HELPER.onError(response, e);
        }
    }

    private void doSearch(boolean searchByTask, SearchPb.Request req, StreamObserver<WorkflowServicePb.WorkflowSummarySearchResult> response) {
        int start = req.getStart();
        int size = GRPC_HELPER.optionalOr(req.getSize(), this.maxSearchSize);
        List<String> sort = this.convertSort(req.getSort());
        String freeText = GRPC_HELPER.optionalOr(req.getFreeText(), "*");
        String query = req.getQuery();
        if (size > this.maxSearchSize) {
            response.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Cannot return more than " + this.maxSearchSize + " results").asRuntimeException());
            return;
        }
        SearchResult search = searchByTask ? this.workflowService.searchWorkflowsByTasks(start, size, sort, freeText, query) : this.workflowService.searchWorkflows(start, size, sort, freeText, query);
        response.onNext((Object)WorkflowServicePb.WorkflowSummarySearchResult.newBuilder().setTotalHits(search.getTotalHits()).addAllResults(search.getResults().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0))::iterator).build());
        response.onCompleted();
    }

    private void doSearchV2(boolean searchByTask, SearchPb.Request req, StreamObserver<WorkflowServicePb.WorkflowSearchResult> response) {
        int start = req.getStart();
        int size = GRPC_HELPER.optionalOr(req.getSize(), this.maxSearchSize);
        List<String> sort = this.convertSort(req.getSort());
        String freeText = GRPC_HELPER.optionalOr(req.getFreeText(), "*");
        String query = req.getQuery();
        if (size > this.maxSearchSize) {
            response.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Cannot return more than " + this.maxSearchSize + " results").asRuntimeException());
            return;
        }
        SearchResult search = searchByTask ? this.workflowService.searchWorkflowsByTasksV2(start, size, sort, freeText, query) : this.workflowService.searchWorkflowsV2(start, size, sort, freeText, query);
        response.onNext((Object)WorkflowServicePb.WorkflowSearchResult.newBuilder().setTotalHits(search.getTotalHits()).addAllResults(search.getResults().stream().map(arg_0 -> ((ProtoMapper)PROTO_MAPPER).toProto(arg_0))::iterator).build());
        response.onCompleted();
    }

    private List<String> convertSort(String sortStr) {
        List<String> list = new ArrayList<String>();
        if (sortStr != null && sortStr.length() != 0) {
            list = Arrays.asList(sortStr.split("\\|"));
        }
        return list;
    }

    public void search(SearchPb.Request request, StreamObserver<WorkflowServicePb.WorkflowSummarySearchResult> responseObserver) {
        this.doSearch(false, request, responseObserver);
    }

    public void searchByTasks(SearchPb.Request request, StreamObserver<WorkflowServicePb.WorkflowSummarySearchResult> responseObserver) {
        this.doSearch(true, request, responseObserver);
    }

    public void searchV2(SearchPb.Request request, StreamObserver<WorkflowServicePb.WorkflowSearchResult> responseObserver) {
        this.doSearchV2(false, request, responseObserver);
    }

    public void searchByTasksV2(SearchPb.Request request, StreamObserver<WorkflowServicePb.WorkflowSearchResult> responseObserver) {
        this.doSearchV2(true, request, responseObserver);
    }
}

