/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.tasks.http.providers;

import com.netflix.conductor.tasks.http.HttpTask;
import com.netflix.conductor.tasks.http.providers.RestTemplateProvider;
import java.time.Duration;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DefaultRestTemplateProvider
implements RestTemplateProvider {
    private final ThreadLocal<RestTemplate> threadLocalRestTemplate = ThreadLocal.withInitial(RestTemplate::new);
    private final int defaultReadTimeout;
    private final int defaultConnectTimeout;

    @Autowired
    public DefaultRestTemplateProvider(@Value(value="${conductor.tasks.http.readTimeout:150ms}") Duration readTimeout, @Value(value="${conductor.tasks.http.connectTimeout:100ms}") Duration connectTimeout) {
        this.defaultReadTimeout = (int)readTimeout.toMillis();
        this.defaultConnectTimeout = (int)connectTimeout.toMillis();
    }

    @Override
    @NonNull
    public RestTemplate getRestTemplate(@NonNull HttpTask.Input input) {
        RestTemplate restTemplate = this.threadLocalRestTemplate.get();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setConnectTimeout(Optional.ofNullable(input.getConnectionTimeOut()).orElse(this.defaultConnectTimeout).intValue());
        requestFactory.setReadTimeout(Optional.ofNullable(input.getReadTimeOut()).orElse(this.defaultReadTimeout).intValue());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }
}

