/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.tasks.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.core.execution.WorkflowExecutor;
import com.netflix.conductor.core.execution.tasks.WorkflowSystemTask;
import com.netflix.conductor.core.utils.Utils;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.model.WorkflowModel;
import com.netflix.conductor.tasks.http.providers.RestTemplateProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component(value="HTTP")
public class HttpTask
extends WorkflowSystemTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTask.class);
    public static final String REQUEST_PARAMETER_NAME = "http_request";
    static final String MISSING_REQUEST = "Missing HTTP request. Task input MUST have a 'http_request' key with HttpTask.Input as value. See documentation for HttpTask for required input parameters";
    private final TypeReference<Map<String, Object>> mapOfObj = new TypeReference<Map<String, Object>>(){};
    private final TypeReference<List<Object>> listOfObj = new TypeReference<List<Object>>(){};
    protected ObjectMapper objectMapper;
    protected RestTemplateProvider restTemplateProvider;
    private final String requestParameter;

    @Autowired
    public HttpTask(RestTemplateProvider restTemplateProvider, ObjectMapper objectMapper) {
        this("HTTP", restTemplateProvider, objectMapper);
    }

    public HttpTask(String name, RestTemplateProvider restTemplateProvider, ObjectMapper objectMapper) {
        super(name);
        this.restTemplateProvider = restTemplateProvider;
        this.objectMapper = objectMapper;
        this.requestParameter = REQUEST_PARAMETER_NAME;
        LOGGER.info("{} initialized...", (Object)this.getTaskType());
    }

    public void start(WorkflowModel workflow, TaskModel task, WorkflowExecutor executor) {
        Object request = task.getInputData().get(this.requestParameter);
        task.setWorkerId(Utils.getServerId());
        if (request == null) {
            task.setReasonForIncompletion(MISSING_REQUEST);
            task.setStatus(TaskModel.Status.FAILED);
            return;
        }
        Input input = (Input)this.objectMapper.convertValue(request, Input.class);
        if (input.getUri() == null) {
            String reason = "Missing HTTP URI.  See documentation for HttpTask for required input parameters";
            task.setReasonForIncompletion(reason);
            task.setStatus(TaskModel.Status.FAILED);
            return;
        }
        if (input.getMethod() == null) {
            String reason = "No HTTP method specified";
            task.setReasonForIncompletion(reason);
            task.setStatus(TaskModel.Status.FAILED);
            return;
        }
        try {
            HttpResponse response = this.httpCall(input);
            LOGGER.debug("Response: {}, {}, task:{}", new Object[]{response.statusCode, response.body, task.getTaskId()});
            if (response.statusCode > 199 && response.statusCode < 300) {
                if (this.isAsyncComplete(task)) {
                    task.setStatus(TaskModel.Status.IN_PROGRESS);
                } else {
                    task.setStatus(TaskModel.Status.COMPLETED);
                }
            } else {
                if (response.body != null) {
                    task.setReasonForIncompletion(response.body.toString());
                } else {
                    task.setReasonForIncompletion("No response from the remote service");
                }
                task.setStatus(TaskModel.Status.FAILED);
            }
            if (response != null) {
                task.addOutput("response", response.asMap());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to invoke {} task: {} - uri: {}, vipAddress: {} in workflow: {}", new Object[]{this.getTaskType(), task.getTaskId(), input.getUri(), input.getVipAddress(), task.getWorkflowInstanceId(), e});
            task.setStatus(TaskModel.Status.FAILED);
            task.setReasonForIncompletion("Failed to invoke " + this.getTaskType() + " task due to: " + e);
            task.addOutput("response", (Object)e.toString());
        }
    }

    protected HttpResponse httpCall(Input input) throws Exception {
        RestTemplate restTemplate = this.restTemplateProvider.getRestTemplate(input);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.valueOf((String)input.getContentType()));
        headers.setAccept(Collections.singletonList(MediaType.valueOf((String)input.getAccept())));
        input.headers.forEach((key, value) -> {
            if (value != null) {
                headers.add(key, value.toString());
            }
        });
        HttpEntity request = new HttpEntity(input.getBody(), (MultiValueMap)headers);
        HttpResponse response = new HttpResponse();
        try {
            ResponseEntity responseEntity = restTemplate.exchange(input.getUri(), input.getMethod(), request, String.class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.hasBody()) {
                response.body = this.extractBody((String)responseEntity.getBody());
            }
            response.statusCode = responseEntity.getStatusCodeValue();
            response.reasonPhrase = responseEntity.getStatusCode().getReasonPhrase();
            response.headers = responseEntity.getHeaders();
            return response;
        }
        catch (RestClientException ex) {
            LOGGER.error(String.format("Got unexpected http response - uri: %s, vipAddress: %s", input.getUri(), input.getVipAddress()), (Throwable)ex);
            String reason = ex.getLocalizedMessage();
            LOGGER.error(reason, (Throwable)ex);
            throw new Exception(reason);
        }
    }

    private Object extractBody(String responseBody) {
        try {
            JsonNode node = this.objectMapper.readTree(responseBody);
            if (node.isArray()) {
                return this.objectMapper.convertValue((Object)node, this.listOfObj);
            }
            if (node.isObject()) {
                return this.objectMapper.convertValue((Object)node, this.mapOfObj);
            }
            if (node.isNumber()) {
                return this.objectMapper.convertValue((Object)node, Double.class);
            }
            return node.asText();
        }
        catch (IOException jpe) {
            LOGGER.error("Error extracting response body", (Throwable)jpe);
            return responseBody;
        }
    }

    public boolean execute(WorkflowModel workflow, TaskModel task, WorkflowExecutor executor) {
        return false;
    }

    public void cancel(WorkflowModel workflow, TaskModel task, WorkflowExecutor executor) {
        task.setStatus(TaskModel.Status.CANCELED);
    }

    public boolean isAsync() {
        return true;
    }

    public static class Input {
        private HttpMethod method;
        private String vipAddress;
        private String appName;
        private Map<String, Object> headers = new HashMap<String, Object>();
        private String uri;
        private Object body;
        private String accept = "application/json";
        private String contentType = "application/json";
        private Integer connectionTimeOut;
        private Integer readTimeOut;

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = HttpMethod.valueOf((String)method);
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        public Object getBody() {
            return this.body;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getVipAddress() {
            return this.vipAddress;
        }

        public void setVipAddress(String vipAddress) {
            this.vipAddress = vipAddress;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public Integer getConnectionTimeOut() {
            return this.connectionTimeOut;
        }

        public Integer getReadTimeOut() {
            return this.readTimeOut;
        }

        public void setConnectionTimeOut(Integer connectionTimeOut) {
            this.connectionTimeOut = connectionTimeOut;
        }

        public void setReadTimeOut(Integer readTimeOut) {
            this.readTimeOut = readTimeOut;
        }
    }

    public static class HttpResponse {
        public Object body;
        public MultiValueMap<String, String> headers;
        public int statusCode;
        public String reasonPhrase;

        public String toString() {
            return "HttpResponse [body=" + this.body + ", headers=" + this.headers + ", statusCode=" + this.statusCode + ", reasonPhrase=" + this.reasonPhrase + "]";
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("body", this.body);
            map.put("headers", this.headers);
            map.put("statusCode", this.statusCode);
            map.put("reasonPhrase", this.reasonPhrase);
            return map;
        }
    }
}

