/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.dao.QueueDAO;
import com.netflix.conductor.service.ExecutionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="/admin", produces="application/json", consumes="application/json", tags={"Admin"})
@Path(value="/admin")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class AdminResource {
    private static Logger logger = LoggerFactory.getLogger(AdminResource.class);
    private Configuration config;
    private ExecutionService service;
    private QueueDAO queue;
    private String version;
    private String buildDate;

    @Inject
    public AdminResource(Configuration config, ExecutionService service, QueueDAO queue) {
        this.config = config;
        this.service = service;
        this.queue = queue;
        this.version = "UNKNOWN";
        this.buildDate = "UNKNOWN";
        try {
            InputStream propertiesIs = this.getClass().getClassLoader().getResourceAsStream("META-INF/conductor-core.properties");
            Properties prop = new Properties();
            prop.load(propertiesIs);
            this.version = prop.getProperty("Implementation-Version");
            this.buildDate = prop.getProperty("Build-Date");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="Get all the configuration parameters")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Map<String, Object> getAllConfig() {
        Map map = this.config.getAll();
        map.put("version", this.version);
        map.put("buildDate", this.buildDate);
        return map;
    }

    @GET
    @Path(value="/task/{tasktype}")
    @ApiOperation(value="Get the list of pending tasks for a given task type")
    @Consumes(value={"*/*"})
    public List<Task> view(@PathParam(value="tasktype") String taskType, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @DefaultValue(value="100") @QueryParam(value="count") Integer count) throws Exception {
        List tasks = this.service.getPendingTasksForTaskType(taskType);
        int total = start + count;
        int n = total = tasks.size() > total ? total : tasks.size();
        if (start > tasks.size()) {
            start = tasks.size();
        }
        return tasks.subList(start, total);
    }

    @POST
    @Path(value="/sweep/requeue/{workflowId}")
    @ApiOperation(value="Queue up all the running workflows for sweep")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String requeueSweep(@PathParam(value="workflowId") String workflowId) throws Exception {
        boolean pushed = this.queue.pushIfNotExists("_deciderQueue", workflowId, (long)this.config.getSweepFrequency());
        return pushed + "." + workflowId;
    }
}

