/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.metrics.Monitors;
import com.sun.jersey.api.core.HttpContext;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class ApplicationExceptionMapper
implements ExceptionMapper<ApplicationException> {
    private static Logger logger = LoggerFactory.getLogger(ApplicationExceptionMapper.class);
    private static List<Variant> supportedMediaTypes = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE, MediaType.TEXT_PLAIN_TYPE}).add().build();
    @Context
    private HttpContext context;
    private String host;

    @Inject
    public ApplicationExceptionMapper(Configuration config) {
        this.host = config.getServerId();
    }

    public Response toResponse(ApplicationException e) {
        MediaType mediaType;
        logger.error(e.getMessage(), (Throwable)e);
        if (e.getHttpStatusCode() == 500) {
            Monitors.error((String)"error", (String)"error");
        }
        if ((mediaType = this.context.getRequest().selectVariant(supportedMediaTypes).getMediaType()) == null) {
            mediaType = MediaType.APPLICATION_JSON_TYPE;
        }
        Map entityMap = e.toMap();
        entityMap.put("instance", this.host);
        Object entity = entityMap;
        if (mediaType == null || MediaType.APPLICATION_JSON_TYPE != mediaType) {
            entity = e.toMap().toString();
        }
        return Response.status((int)e.getHttpStatusCode()).entity(entity).type(mediaType).build();
    }
}

