/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.service.MetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/metadata", produces="application/json", consumes="application/json", tags={"Metadata Management"})
@Path(value="/metadata")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class MetadataResource {
    private MetadataService service;

    @Inject
    public MetadataResource(MetadataService service) {
        this.service = service;
    }

    @POST
    @Path(value="/workflow")
    @ApiOperation(value="Create a new workflow definition")
    public void create(WorkflowDef def) throws Exception {
        this.service.registerWorkflowDef(def);
    }

    @PUT
    @Path(value="/workflow")
    @ApiOperation(value="Create or update workflow definition")
    public void update(List<WorkflowDef> defs) throws Exception {
        this.service.updateWorkflowDef(defs);
    }

    @GET
    @ApiOperation(value="Retrieves workflow definition along with blueprint")
    @Path(value="/workflow/{name}")
    public WorkflowDef get(@PathParam(value="name") String name, @QueryParam(value="version") Integer version) throws Exception {
        return this.service.getWorkflowDef(name, version);
    }

    @GET
    @ApiOperation(value="Retrieves all workflow definition along with blueprint")
    @Path(value="/workflow")
    public List<WorkflowDef> getAll() throws Exception {
        return this.service.getWorkflowDefs();
    }

    @POST
    @Path(value="/taskdefs")
    @ApiOperation(value="Create new task definition(s)")
    public void registerTaskDef(List<TaskDef> taskDefs) throws Exception {
        this.service.registerTaskDef(taskDefs);
    }

    @PUT
    @Path(value="/taskdefs")
    @ApiOperation(value="Update an existing task")
    public void registerTaskDef(TaskDef taskDef) throws Exception {
        this.service.updateTaskDef(taskDef);
    }

    @GET
    @Path(value="/taskdefs")
    @ApiOperation(value="Gets all task definition")
    @Consumes(value={"*/*"})
    public List<TaskDef> getTaskDefs() throws Exception {
        return this.service.getTaskDefs();
    }

    @GET
    @Path(value="/taskdefs/{tasktype}")
    @ApiOperation(value="Gets the task definition")
    @Consumes(value={"*/*"})
    public TaskDef getTaskDef(@PathParam(value="tasktype") String taskType) throws Exception {
        return this.service.getTaskDef(taskType);
    }

    @DELETE
    @Path(value="/taskdefs/{tasktype}")
    @ApiOperation(value="Remove a task definition")
    public void unregisterTaskDef(@PathParam(value="tasktype") String taskType) {
        this.service.unregisterTaskDef(taskType);
    }
}

