/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.dao.QueueDAO;
import com.netflix.conductor.service.ExecutionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/tasks", produces="application/json", consumes="application/json", tags={"Task Management"})
@Path(value="/tasks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class TaskResource {
    private ExecutionService taskService;
    private QueueDAO queues;

    @Inject
    public TaskResource(ExecutionService taskService, QueueDAO queues) {
        this.taskService = taskService;
        this.queues = queues;
    }

    @GET
    @Path(value="/poll/{tasktype}")
    @ApiOperation(value="Poll for a task of a certain type")
    @Consumes(value={"*/*"})
    public Task poll(@PathParam(value="tasktype") String taskType, @QueryParam(value="workerid") String workerId) throws Exception {
        List tasks = this.taskService.poll(taskType, workerId, 1, 100);
        if (tasks.isEmpty()) {
            return null;
        }
        return (Task)tasks.get(0);
    }

    @GET
    @Path(value="/poll/batch/{tasktype}")
    @ApiOperation(value="batch Poll for a task of a certain type")
    @Consumes(value={"*/*"})
    public List<Task> batchPoll(@PathParam(value="tasktype") String taskType, @QueryParam(value="workerid") String workerId, @DefaultValue(value="1") @QueryParam(value="count") Integer count, @DefaultValue(value="100") @QueryParam(value="timeout") Integer timeout) throws Exception {
        return this.taskService.poll(taskType, workerId, count.intValue(), timeout.intValue());
    }

    @GET
    @Path(value="/in_progress/{tasktype}")
    @ApiOperation(value="Get in progress tasks.  The results are paginated.")
    @Consumes(value={"*/*"})
    public List<Task> getTasks(@PathParam(value="tasktype") String taskType, @QueryParam(value="startKey") String startKey, @QueryParam(value="count") @DefaultValue(value="100") Integer count) throws Exception {
        return this.taskService.getTasks(taskType, startKey, count.intValue());
    }

    @GET
    @Path(value="/in_progress/{workflowId}/{taskRefName}")
    @ApiOperation(value="Get in progress task for a given workflow id.")
    @Consumes(value={"*/*"})
    public Task getPendingTaskForWorkflow(@PathParam(value="workflowId") String workflowId, @PathParam(value="taskRefName") String taskReferenceName) throws Exception {
        return this.taskService.getPendingTaskForWorkflow(taskReferenceName, workflowId);
    }

    @POST
    @ApiOperation(value="Update a task")
    public String updateTask(TaskResult task) throws Exception {
        this.taskService.updateTask(task);
        return "\"" + task.getTaskId() + "\"";
    }

    @POST
    @Path(value="/{taskId}/ack")
    @ApiOperation(value="Ack Task is recieved")
    @Consumes(value={"*/*"})
    public String ack(@PathParam(value="taskId") String taskId, @QueryParam(value="workerid") String workerId) throws Exception {
        return "" + this.taskService.ackTaskRecieved(taskId, workerId);
    }

    @GET
    @Path(value="/{taskId}")
    @ApiOperation(value="Get task by Id")
    @Consumes(value={"*/*"})
    public Task getTask(@PathParam(value="taskId") String taskId) throws Exception {
        return this.taskService.getTask(taskId);
    }

    @DELETE
    @Path(value="/queue/{taskType}/{taskId}")
    @ApiOperation(value="Remove Task from a Task type queue")
    @Consumes(value={"*/*"})
    public void remvoeTaskFromQueue(@PathParam(value="taskType") String taskType, @PathParam(value="taskId") String taskId) throws Exception {
        this.taskService.removeTaskfromQueue(taskType, taskId);
    }

    @GET
    @Path(value="/queue/sizes")
    @ApiOperation(value="Get Task type queue sizes")
    @Consumes(value={"*/*"})
    public Map<String, Integer> size(@QueryParam(value="taskType") List<String> taskTypes) throws Exception {
        return this.taskService.getTaskQueueSizes(taskTypes);
    }

    @GET
    @Path(value="/queue/all/verbose")
    @ApiOperation(value="Get the details about each queue")
    @Consumes(value={"*/*"})
    public Map<String, Map<String, Map<String, Long>>> allVerbose() throws Exception {
        return this.queues.queuesDetailVerbose();
    }

    @GET
    @Path(value="/queue/all")
    @ApiOperation(value="Get the details about each queue")
    @Consumes(value={"*/*"})
    public Map<String, Long> all() throws Exception {
        Map all = this.queues.queuesDetail();
        Set entries = all.entrySet();
        TreeSet<Map.Entry<String, Long>> sorted = new TreeSet<Map.Entry<String, Long>>(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        sorted.addAll(entries);
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        sorted.stream().forEach(e -> {
            Long cfr_ignored_0 = (Long)sortedMap.put((String)e.getKey(), (Long)e.getValue());
        });
        return sortedMap;
    }

    @POST
    @Path(value="/queue/requeue")
    @ApiOperation(value="Requeue pending tasks for all the running workflows")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain", "application/json"})
    public String requeue() throws Exception {
        return "" + this.taskService.requeuePendingTasks();
    }

    @POST
    @Path(value="/queue/requeue/{taskType}")
    @ApiOperation(value="Requeue pending tasks")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain", "application/json"})
    public String requeue(@PathParam(value="taskType") String taskType) throws Exception {
        return "" + this.taskService.requeuePendingTasks(taskType);
    }
}

