/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.SkipTaskRequest;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.core.execution.WorkflowExecutor;
import com.netflix.conductor.service.ExecutionService;
import com.netflix.conductor.service.MetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/workflow", produces="application/json", consumes="application/json", tags={"Workflow Management"})
@Path(value="/workflow")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class WorkflowResource {
    private WorkflowExecutor executor;
    private ExecutionService service;
    private MetadataService metadata;
    private int maxSearchSize;

    @Inject
    public WorkflowResource(WorkflowExecutor executor, ExecutionService service, MetadataService metadata, Configuration config) {
        this.executor = executor;
        this.service = service;
        this.metadata = metadata;
        this.maxSearchSize = config.getIntProperty("workflow.max.search.size", 5000);
    }

    @POST
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Start a new workflow.  Returns the ID of the workflow instance that can be later used for tracking")
    public String startWorkflow(@PathParam(value="name") String name, @QueryParam(value="version") Integer version, @QueryParam(value="correlationId") String correlationId, Map<String, Object> input) throws Exception {
        WorkflowDef def = this.metadata.getWorkflowDef(name, version);
        if (def == null) {
            throw new ApplicationException(ApplicationException.Code.NOT_FOUND, "No such workflow found by name=" + name + ", version=" + version);
        }
        return this.executor.startWorkflow(def.getName(), def.getVersion(), correlationId, input, null);
    }

    @GET
    @Path(value="/{name}/correlated/{correlationId}")
    @ApiOperation(value="Lists workflows for the given correlation id")
    @Consumes(value={"*/*"})
    public List<Workflow> getWorkflows(@PathParam(value="name") String name, @PathParam(value="correlationId") String correlationId, @QueryParam(value="includeClosed") @DefaultValue(value="false") boolean includeClosed, @QueryParam(value="includeTasks") @DefaultValue(value="false") boolean includeTasks) throws Exception {
        return this.service.getWorkflowInstances(name, correlationId, includeClosed, includeTasks);
    }

    @GET
    @Path(value="/{workflowId}")
    @ApiOperation(value="Gets the workflow by workflow id")
    @Consumes(value={"*/*"})
    public Workflow getExecutionStatus(@PathParam(value="workflowId") String workflowId, @QueryParam(value="includeTasks") @DefaultValue(value="true") boolean includeTasks) throws Exception {
        return this.service.getExecutionStatus(workflowId, includeTasks);
    }

    @DELETE
    @Path(value="/{workflowId}/remove")
    @ApiOperation(value="Removes the workflow from the system")
    @Consumes(value={"*/*"})
    public void delete(@PathParam(value="workflowId") String workflowId) throws Exception {
        this.service.removeWorkflow(workflowId);
    }

    @GET
    @Path(value="/running/{name}")
    @ApiOperation(value="Retrieve all the running workflows")
    @Consumes(value={"*/*"})
    public List<String> getRunningWorkflow(@PathParam(value="name") String workflowName, @QueryParam(value="version") @DefaultValue(value="1") Integer version, @QueryParam(value="startTime") Long startTime, @QueryParam(value="endTime") Long endTime) throws Exception {
        if (startTime != null && endTime != null) {
            return this.executor.getWorkflows(workflowName, version, startTime, endTime);
        }
        return this.executor.getRunningWorkflowIds(workflowName);
    }

    @PUT
    @Path(value="/decide/{workflowId}")
    @ApiOperation(value="Starts the decision task for a workflow")
    @Consumes(value={"*/*"})
    public void decide(@PathParam(value="workflowId") String workflowId) throws Exception {
        this.executor.decide(workflowId);
    }

    @PUT
    @Path(value="/{workflowId}/pause")
    @ApiOperation(value="Pauses the workflow")
    @Consumes(value={"*/*"})
    public void pauseWorkflow(@PathParam(value="workflowId") String workflowId) throws Exception {
        this.executor.pauseWorkflow(workflowId);
    }

    @PUT
    @Path(value="/{workflowId}/resume")
    @ApiOperation(value="Resumes the workflow")
    @Consumes(value={"*/*"})
    public void resumeWorkflow(@PathParam(value="workflowId") String workflowId) throws Exception {
        this.executor.resumeWorkflow(workflowId);
    }

    @PUT
    @Path(value="/{workflowId}/skiptask/{taskReferenceName}")
    @ApiOperation(value="Skips a given task from a current running workflow")
    @Consumes(value={"*/*"})
    public void skipTaskFromWorkflow(@PathParam(value="workflowId") String workflowId, @PathParam(value="taskReferenceName") String taskReferenceName, SkipTaskRequest skipTaskRequest) throws Exception {
        this.executor.skipTaskFromWorkflow(workflowId, taskReferenceName, skipTaskRequest);
    }

    @POST
    @Path(value="/{workflowId}/rerun")
    @ApiOperation(value="Reruns the workflow from a specific task")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain", "application/json"})
    public String rerun(@PathParam(value="workflowId") String workflowId, RerunWorkflowRequest request) throws Exception {
        request.setReRunFromWorkflowId(workflowId);
        return this.executor.rerun(request);
    }

    @POST
    @Path(value="/{workflowId}/restart")
    @ApiOperation(value="Restarts a completed workflow")
    @Consumes(value={"*/*"})
    public void restart(@PathParam(value="workflowId") String workflowId) throws Exception {
        this.executor.rewind(workflowId);
    }

    @POST
    @Path(value="/{workflowId}/retry")
    @ApiOperation(value="Retries the last failed task")
    @Consumes(value={"*/*"})
    public void retry(@PathParam(value="workflowId") String workflowId) throws Exception {
        this.executor.retry(workflowId);
    }

    @DELETE
    @Path(value="/{workflowId}")
    @ApiOperation(value="Terminate workflow execution")
    @Consumes(value={"*/*"})
    public void terminate(@PathParam(value="workflowId") String workflowId, @QueryParam(value="reason") String reason) throws Exception {
        this.executor.terminateWorkflow(workflowId, reason);
    }

    @ApiOperation(value="Search for workflows based in payload and other parameters", notes="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC.  If order is not specified, defaults to ASC")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public SearchResult<WorkflowSummary> search(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="size") @DefaultValue(value="100") int size, @QueryParam(value="sort") String sort, @QueryParam(value="freeText") @DefaultValue(value="*") String freeText, @QueryParam(value="query") String query) {
        if (size > this.maxSearchSize) {
            throw new ApplicationException(ApplicationException.Code.INVALID_INPUT, "Cannot return more than " + this.maxSearchSize + " workflows.  Please use pagination");
        }
        return this.service.search(query, freeText, start, size, this.convert(sort));
    }

    private List<String> convert(String sortStr) {
        List<String> list = new ArrayList<String>();
        if (sortStr != null && sortStr.length() != 0) {
            list = Arrays.asList(sortStr.split("\\|"));
        }
        return list;
    }
}

