/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.service.AdminService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/admin", produces="application/json", consumes="application/json", tags={"Admin"})
@Path(value="/admin")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class AdminResource {
    private final AdminService adminService;

    @Inject
    public AdminResource(AdminService adminService) {
        this.adminService = adminService;
    }

    @ApiOperation(value="Get all the configuration parameters")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Map<String, Object> getAllConfig() {
        return this.adminService.getAllConfig();
    }

    @GET
    @Path(value="/task/{tasktype}")
    @ApiOperation(value="Get the list of pending tasks for a given task type")
    @Consumes(value={"*/*"})
    public List<Task> view(@PathParam(value="tasktype") String taskType, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @DefaultValue(value="100") @QueryParam(value="count") Integer count) {
        return this.adminService.getListOfPendingTask(taskType, start, count);
    }

    @POST
    @Path(value="/sweep/requeue/{workflowId}")
    @ApiOperation(value="Queue up all the running workflows for sweep")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String requeueSweep(@PathParam(value="workflowId") String workflowId) {
        return this.adminService.requeueSweep(workflowId);
    }

    @POST
    @Path(value="/consistency/verifyAndRepair/{workflowId}")
    @ApiOperation(value="Verify and repair workflow consistency")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String verifyAndRepairWorkflowConsistency(@PathParam(value="workflowId") String workflowId) {
        return String.valueOf(this.adminService.verifyAndRepairWorkflowConsistency(workflowId));
    }
}

