/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.metrics.Monitors;
import com.sun.jersey.api.core.HttpContext;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class ApplicationExceptionMapper
implements ExceptionMapper<ApplicationException> {
    private static Logger LOGGER = LoggerFactory.getLogger(ApplicationExceptionMapper.class);
    @Context
    private HttpContext context;
    @Context
    private UriInfo uriInfo;
    @Context
    private javax.inject.Provider<Request> request;
    private String host;

    @Inject
    public ApplicationExceptionMapper(Configuration config) {
        this.host = config.getServerId();
    }

    public Response toResponse(ApplicationException e) {
        this.logException(e);
        Response.ResponseBuilder responseBuilder = Response.status((int)e.getHttpStatusCode());
        if (e.getHttpStatusCode() == 500) {
            Monitors.error((String)"error", (String)"error");
        }
        Map entityMap = e.toMap();
        entityMap.put("instance", this.host);
        responseBuilder.type(MediaType.APPLICATION_JSON_TYPE);
        responseBuilder.entity((Object)entityMap);
        return responseBuilder.build();
    }

    @VisibleForTesting
    UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @VisibleForTesting
    Request getRequest() {
        return (Request)this.request.get();
    }

    private void logException(ApplicationException exception) {
        LOGGER.error(String.format("Error %s url: '%s'", exception.getClass().getSimpleName(), this.getUriInfo().getPath()), (Throwable)exception);
    }
}

