/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.service.EventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/event", produces="application/json", consumes="application/json", tags={"Event Services"})
@Path(value="/event")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class EventResource {
    private final EventService eventService;

    @Inject
    public EventResource(EventService eventService) {
        this.eventService = eventService;
    }

    @POST
    @ApiOperation(value="Add a new event handler.")
    public void addEventHandler(EventHandler eventHandler) {
        this.eventService.addEventHandler(eventHandler);
    }

    @PUT
    @ApiOperation(value="Update an existing event handler.")
    public void updateEventHandler(EventHandler eventHandler) {
        this.eventService.updateEventHandler(eventHandler);
    }

    @DELETE
    @Path(value="/{name}")
    @ApiOperation(value="Remove an event handler")
    public void removeEventHandlerStatus(@PathParam(value="name") String name) {
        this.eventService.removeEventHandlerStatus(name);
    }

    @GET
    @ApiOperation(value="Get all the event handlers")
    public List<EventHandler> getEventHandlers() {
        return this.eventService.getEventHandlers();
    }

    @GET
    @Path(value="/{event}")
    @ApiOperation(value="Get event handlers for a given event")
    public List<EventHandler> getEventHandlersForEvent(@PathParam(value="event") String event, @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        return this.eventService.getEventHandlersForEvent(event, activeOnly);
    }

    @GET
    @Path(value="/queues")
    @ApiOperation(value="Get registered queues")
    public Map<String, ?> getEventQueues(@QueryParam(value="verbose") @DefaultValue(value="false") boolean verbose) {
        return this.eventService.getEventQueues(verbose);
    }

    @GET
    @Path(value="/queues/providers")
    @ApiOperation(value="Get registered queue providers")
    public List<String> getEventQueueProviders() {
        return this.eventService.getEventQueueProviders();
    }
}

