/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.metrics.Monitors;
import com.sun.jersey.api.core.HttpContext;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class GenericExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericExceptionMapper.class);
    @Context
    private HttpContext context;
    @Context
    private UriInfo uriInfo;
    private String host;

    @Inject
    public GenericExceptionMapper(Configuration config) {
        this.host = config.getServerId();
    }

    public Response toResponse(Throwable exception) {
        LOGGER.error(String.format("Error %s url: '%s'", exception.getClass().getSimpleName(), this.uriInfo.getPath()), exception);
        Monitors.error((String)"error", (String)"error");
        ApplicationException applicationException = null;
        applicationException = exception instanceof IllegalArgumentException || exception instanceof InvalidFormatException ? new ApplicationException(ApplicationException.Code.INVALID_INPUT, exception.getMessage(), exception) : new ApplicationException(ApplicationException.Code.INTERNAL_ERROR, exception.getMessage(), exception);
        Map entityMap = applicationException.toMap();
        entityMap.put("instance", this.host);
        return Response.status((int)applicationException.getHttpStatusCode()).entity((Object)entityMap).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

