/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.service.TaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/tasks", produces="application/json", consumes="application/json", tags={"Task Management"})
@Path(value="/tasks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class TaskResource {
    private final TaskService taskService;

    @Inject
    public TaskResource(TaskService taskService) {
        this.taskService = taskService;
    }

    @GET
    @Path(value="/poll/{tasktype}")
    @ApiOperation(value="Poll for a task of a certain type")
    @Consumes(value={"*/*"})
    public Task poll(@PathParam(value="tasktype") String taskType, @QueryParam(value="workerid") String workerId, @QueryParam(value="domain") String domain) {
        return this.taskService.poll(taskType, workerId, domain);
    }

    @GET
    @Path(value="/poll/batch/{tasktype}")
    @ApiOperation(value="batch Poll for a task of a certain type")
    @Consumes(value={"*/*"})
    public List<Task> batchPoll(@PathParam(value="tasktype") String taskType, @QueryParam(value="workerid") String workerId, @QueryParam(value="domain") String domain, @DefaultValue(value="1") @QueryParam(value="count") Integer count, @DefaultValue(value="100") @QueryParam(value="timeout") Integer timeout) {
        return this.taskService.batchPoll(taskType, workerId, domain, count, timeout);
    }

    @GET
    @Path(value="/in_progress/{tasktype}")
    @ApiOperation(value="Get in progress tasks. The results are paginated.")
    @Consumes(value={"*/*"})
    public List<Task> getTasks(@PathParam(value="tasktype") String taskType, @QueryParam(value="startKey") String startKey, @QueryParam(value="count") @DefaultValue(value="100") Integer count) {
        return this.taskService.getTasks(taskType, startKey, count);
    }

    @GET
    @Path(value="/in_progress/{workflowId}/{taskRefName}")
    @ApiOperation(value="Get in progress task for a given workflow id.")
    @Consumes(value={"*/*"})
    public Task getPendingTaskForWorkflow(@PathParam(value="workflowId") String workflowId, @PathParam(value="taskRefName") String taskReferenceName) {
        return this.taskService.getPendingTaskForWorkflow(workflowId, taskReferenceName);
    }

    @POST
    @ApiOperation(value="Update a task")
    @Produces(value={"text/plain", "application/json"})
    public String updateTask(TaskResult taskResult) {
        return this.taskService.updateTask(taskResult);
    }

    @POST
    @Path(value="/{taskId}/ack")
    @ApiOperation(value="Ack Task is received")
    @Consumes(value={"*/*"})
    public String ack(@PathParam(value="taskId") String taskId, @QueryParam(value="workerid") String workerId) {
        return this.taskService.ackTaskReceived(taskId, workerId);
    }

    @POST
    @Path(value="/{taskId}/log")
    @ApiOperation(value="Log Task Execution Details")
    public void log(@PathParam(value="taskId") String taskId, String log) {
        this.taskService.log(taskId, log);
    }

    @GET
    @Path(value="/{taskId}/log")
    @ApiOperation(value="Get Task Execution Logs")
    public List<TaskExecLog> getTaskLogs(@PathParam(value="taskId") String taskId) {
        return this.taskService.getTaskLogs(taskId);
    }

    @GET
    @Path(value="/{taskId}")
    @ApiOperation(value="Get task by Id")
    @Consumes(value={"*/*"})
    public Task getTask(@PathParam(value="taskId") String taskId) {
        return this.taskService.getTask(taskId);
    }

    @DELETE
    @Path(value="/queue/{taskType}/{taskId}")
    @ApiOperation(value="Remove Task from a Task type queue")
    @Consumes(value={"*/*"})
    public void removeTaskFromQueue(@PathParam(value="taskType") String taskType, @PathParam(value="taskId") String taskId) {
        this.taskService.removeTaskFromQueue(taskType, taskId);
    }

    @GET
    @Path(value="/queue/sizes")
    @ApiOperation(value="Get Task type queue sizes")
    @Consumes(value={"*/*"})
    public Map<String, Integer> size(@QueryParam(value="taskType") List<String> taskTypes) {
        return this.taskService.getTaskQueueSizes(taskTypes);
    }

    @GET
    @Path(value="/queue/all/verbose")
    @ApiOperation(value="Get the details about each queue")
    @Consumes(value={"*/*"})
    public Map<String, Map<String, Map<String, Long>>> allVerbose() {
        return this.taskService.allVerbose();
    }

    @GET
    @Path(value="/queue/all")
    @ApiOperation(value="Get the details about each queue")
    @Consumes(value={"*/*"})
    public Map<String, Long> all() {
        return this.taskService.getAllQueueDetails();
    }

    @GET
    @Path(value="/queue/polldata")
    @ApiOperation(value="Get the last poll data for a given task type")
    @Consumes(value={"*/*"})
    public List<PollData> getPollData(@QueryParam(value="taskType") String taskType) {
        return this.taskService.getPollData(taskType);
    }

    @GET
    @Path(value="/queue/polldata/all")
    @ApiOperation(value="Get the last poll data for all task types")
    @Consumes(value={"*/*"})
    public List<PollData> getAllPollData() {
        return this.taskService.getAllPollData();
    }

    @Deprecated
    @POST
    @Path(value="/queue/requeue")
    @ApiOperation(value="Requeue pending tasks for all the running workflows")
    public String requeue() {
        return this.taskService.requeue();
    }

    @POST
    @Path(value="/queue/requeue/{taskType}")
    @ApiOperation(value="Requeue pending tasks")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain", "application/json"})
    public String requeuePendingTask(@PathParam(value="taskType") String taskType) {
        return this.taskService.requeuePendingTask(taskType);
    }

    @ApiOperation(value="Search for tasks based in payload and other parameters", notes="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public SearchResult<TaskSummary> search(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="size") @DefaultValue(value="100") int size, @QueryParam(value="sort") String sort, @QueryParam(value="freeText") @DefaultValue(value="*") String freeText, @QueryParam(value="query") String query) {
        return this.taskService.search(start, size, sort, freeText, query);
    }

    @GET
    @ApiOperation(value="Get the external uri where the task payload is to be stored")
    @Consumes(value={"*/*"})
    @Path(value="/externalstoragelocation")
    public ExternalStorageLocation getExternalStorageLocation(@QueryParam(value="path") String path, @QueryParam(value="operation") String operation, @QueryParam(value="payloadType") String payloadType) {
        return this.taskService.getExternalStorageLocation(path, operation, payloadType);
    }
}

