/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.conductor.common.validation.ErrorResponse;
import com.netflix.conductor.common.validation.ValidationError;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.server.resources.ApplicationExceptionMapper;
import com.sun.jersey.api.core.HttpContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static Logger LOGGER = LoggerFactory.getLogger(ApplicationExceptionMapper.class);
    @Context
    private HttpContext context;
    @Context
    private UriInfo uriInfo;
    @Context
    private javax.inject.Provider<Request> request;
    private String host;

    @Inject
    public ValidationExceptionMapper(Configuration config) {
        this.host = config.getServerId();
    }

    public Response toResponse(ValidationException exception) {
        Response.ResponseBuilder responseBuilder;
        this.logException(exception);
        if (exception instanceof ConstraintViolationException) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            responseBuilder = Response.serverError();
            Monitors.error((String)"error", (String)"error");
        }
        HashMap<String, String> entityMap = new HashMap<String, String>();
        entityMap.put("instance", this.host);
        responseBuilder.type(MediaType.APPLICATION_JSON_TYPE);
        responseBuilder.entity((Object)ValidationExceptionMapper.toErrorResponse(exception));
        return responseBuilder.build();
    }

    private static ErrorResponse toErrorResponse(ValidationException ve) {
        if (ve instanceof ConstraintViolationException) {
            return ValidationExceptionMapper.constraintViolationExceptionToErrorResponse((ConstraintViolationException)ve);
        }
        ErrorResponse result = new ErrorResponse();
        result.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        result.setMessage(ve.getMessage());
        return result;
    }

    private static ErrorResponse constraintViolationExceptionToErrorResponse(ConstraintViolationException exception) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
        errorResponse.setMessage("Validation failed, check below errors for detail.");
        ArrayList validationErrors = new ArrayList();
        exception.getConstraintViolations().forEach(e -> validationErrors.add(new ValidationError(ValidationExceptionMapper.getViolationPath(e), e.getMessage(), ValidationExceptionMapper.getViolationInvalidValue(e.getInvalidValue()))));
        errorResponse.setValidationErrors(validationErrors);
        return errorResponse;
    }

    private static String getViolationPath(ConstraintViolation violation) {
        String propertyPath = violation.getPropertyPath().toString();
        return !"".equals(propertyPath) ? propertyPath : "";
    }

    private static String getViolationInvalidValue(Object invalidValue) {
        if (invalidValue == null) {
            return null;
        }
        if (invalidValue.getClass().isArray()) {
            if (invalidValue instanceof Object[]) {
                return null;
            }
            if (invalidValue instanceof boolean[]) {
                return Arrays.toString((boolean[])invalidValue);
            }
            if (invalidValue instanceof byte[]) {
                return Arrays.toString((byte[])invalidValue);
            }
            if (invalidValue instanceof char[]) {
                return Arrays.toString((char[])invalidValue);
            }
            if (invalidValue instanceof double[]) {
                return Arrays.toString((double[])invalidValue);
            }
            if (invalidValue instanceof float[]) {
                return Arrays.toString((float[])invalidValue);
            }
            if (invalidValue instanceof int[]) {
                return Arrays.toString((int[])invalidValue);
            }
            if (invalidValue instanceof long[]) {
                return Arrays.toString((long[])invalidValue);
            }
            if (invalidValue instanceof short[]) {
                return Arrays.toString((short[])invalidValue);
            }
        }
        if (invalidValue.getClass().getName().startsWith("java.lang.")) {
            return invalidValue.toString();
        }
        return null;
    }

    @VisibleForTesting
    UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @VisibleForTesting
    Request getRequest() {
        return (Request)this.request.get();
    }

    private void logException(ValidationException exception) {
        LOGGER.error(String.format("Error %s url: '%s'", exception.getClass().getSimpleName(), this.getUriInfo().getPath()), (Throwable)exception);
    }
}

