/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.core.execution.Code;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebAppExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static Logger logger = LoggerFactory.getLogger(WebAppExceptionMapper.class);
    @Context
    private UriInfo uriInfo;
    private final String host;
    private Code code;

    @Inject
    public WebAppExceptionMapper(Configuration config) {
        this.host = config.getServerId();
    }

    public Response toResponse(WebApplicationException exception) {
        logger.error(String.format("Error %s url: '%s'", exception.getClass().getSimpleName(), this.uriInfo.getPath()), (Throwable)exception);
        Response response = exception.getResponse();
        this.code = Code.forValue((int)response.getStatus());
        LinkedHashMap<String, Object> entityMap = new LinkedHashMap<String, Object>();
        entityMap.put("instance", this.host);
        entityMap.put("code", Optional.ofNullable(this.code).map(Enum::name).orElse(null));
        entityMap.put("message", exception.getCause());
        entityMap.put("retryable", false);
        return Response.status((int)response.getStatus()).entity(entityMap).build();
    }
}

