/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.service.WorkflowBulkService;
import com.netflix.conductor.service.common.BulkResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/workflow/bulk", produces="application/json", consumes="application/json", tags={"Workflow Bulk Management"})
@Path(value="/workflow/bulk")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class WorkflowBulkResource {
    private WorkflowBulkService workflowBulkService;

    @Inject
    public WorkflowBulkResource(WorkflowBulkService workflowBulkService) {
        this.workflowBulkService = workflowBulkService;
    }

    @PUT
    @Path(value="/pause")
    @ApiOperation(value="Pause the list of workflows")
    public BulkResponse pauseWorkflow(List<String> workflowIds) {
        return this.workflowBulkService.pauseWorkflow(workflowIds);
    }

    @PUT
    @Path(value="/resume")
    @ApiOperation(value="Resume the list of workflows")
    public BulkResponse resumeWorkflow(List<String> workflowIds) {
        return this.workflowBulkService.resumeWorkflow(workflowIds);
    }

    @POST
    @Path(value="/restart")
    @ApiOperation(value="Restart the list of completed workflow")
    public BulkResponse restart(List<String> workflowIds, @QueryParam(value="useLatestDefinitions") @DefaultValue(value="false") boolean useLatestDefinitions) {
        return this.workflowBulkService.restart(workflowIds, useLatestDefinitions);
    }

    @POST
    @Path(value="/retry")
    @ApiOperation(value="Retry the last failed task for each workflow from the list")
    public BulkResponse retry(List<String> workflowIds) {
        return this.workflowBulkService.retry(workflowIds);
    }

    @DELETE
    @Path(value="/terminate")
    @ApiOperation(value="Terminate workflows execution")
    public BulkResponse terminate(List<String> workflowIds, @QueryParam(value="reason") String reason) {
        return this.workflowBulkService.terminate(workflowIds, reason);
    }
}

