/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.server.resources;

import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.SkipTaskRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.service.WorkflowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="/workflow", produces="application/json", consumes="application/json", tags={"Workflow Management"})
@Path(value="/workflow")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Singleton
public class WorkflowResource {
    private final WorkflowService workflowService;

    @Inject
    public WorkflowResource(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Start a new workflow with StartWorkflowRequest, which allows task to be executed in a domain")
    public String startWorkflow(StartWorkflowRequest request) {
        return this.workflowService.startWorkflow(request);
    }

    @POST
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Start a new workflow. Returns the ID of the workflow instance that can be later used for tracking")
    public String startWorkflow(@PathParam(value="name") String name, @QueryParam(value="version") Integer version, @QueryParam(value="correlationId") String correlationId, @QueryParam(value="priority") @DefaultValue(value="0") Integer priority, Map<String, Object> input) {
        return this.workflowService.startWorkflow(name, version, correlationId, priority, input);
    }

    @GET
    @Path(value="/{name}/correlated/{correlationId}")
    @ApiOperation(value="Lists workflows for the given correlation id")
    @Consumes(value={"*/*"})
    public List<Workflow> getWorkflows(@PathParam(value="name") String name, @PathParam(value="correlationId") String correlationId, @QueryParam(value="includeClosed") @DefaultValue(value="false") boolean includeClosed, @QueryParam(value="includeTasks") @DefaultValue(value="false") boolean includeTasks) {
        return this.workflowService.getWorkflows(name, correlationId, includeClosed, includeTasks);
    }

    @POST
    @Path(value="/{name}/correlated")
    @ApiOperation(value="Lists workflows for the given correlation id list")
    @Consumes(value={"application/json"})
    public Map<String, List<Workflow>> getWorkflows(@PathParam(value="name") String name, @QueryParam(value="includeClosed") @DefaultValue(value="false") boolean includeClosed, @QueryParam(value="includeTasks") @DefaultValue(value="false") boolean includeTasks, List<String> correlationIds) {
        return this.workflowService.getWorkflows(name, includeClosed, includeTasks, correlationIds);
    }

    @GET
    @Path(value="/{workflowId}")
    @ApiOperation(value="Gets the workflow by workflow id")
    @Consumes(value={"*/*"})
    public Workflow getExecutionStatus(@PathParam(value="workflowId") String workflowId, @QueryParam(value="includeTasks") @DefaultValue(value="true") boolean includeTasks) {
        return this.workflowService.getExecutionStatus(workflowId, includeTasks);
    }

    @DELETE
    @Path(value="/{workflowId}/remove")
    @ApiOperation(value="Removes the workflow from the system")
    @Consumes(value={"*/*"})
    public void delete(@PathParam(value="workflowId") String workflowId, @QueryParam(value="archiveWorkflow") @DefaultValue(value="true") boolean archiveWorkflow) {
        this.workflowService.deleteWorkflow(workflowId, archiveWorkflow);
    }

    @GET
    @Path(value="/running/{name}")
    @ApiOperation(value="Retrieve all the running workflows")
    @Consumes(value={"*/*"})
    public List<String> getRunningWorkflow(@PathParam(value="name") String workflowName, @QueryParam(value="version") @DefaultValue(value="1") Integer version, @QueryParam(value="startTime") Long startTime, @QueryParam(value="endTime") Long endTime) {
        return this.workflowService.getRunningWorkflows(workflowName, version, startTime, endTime);
    }

    @PUT
    @Path(value="/decide/{workflowId}")
    @ApiOperation(value="Starts the decision task for a workflow")
    @Consumes(value={"*/*"})
    public void decide(@PathParam(value="workflowId") String workflowId) {
        this.workflowService.decideWorkflow(workflowId);
    }

    @PUT
    @Path(value="/{workflowId}/pause")
    @ApiOperation(value="Pauses the workflow")
    @Consumes(value={"*/*"})
    public void pauseWorkflow(@PathParam(value="workflowId") String workflowId) {
        this.workflowService.pauseWorkflow(workflowId);
    }

    @PUT
    @Path(value="/{workflowId}/resume")
    @ApiOperation(value="Resumes the workflow")
    @Consumes(value={"*/*"})
    public void resumeWorkflow(@PathParam(value="workflowId") String workflowId) {
        this.workflowService.resumeWorkflow(workflowId);
    }

    @PUT
    @Path(value="/{workflowId}/skiptask/{taskReferenceName}")
    @ApiOperation(value="Skips a given task from a current running workflow")
    @Consumes(value={"application/json"})
    public void skipTaskFromWorkflow(@PathParam(value="workflowId") String workflowId, @PathParam(value="taskReferenceName") String taskReferenceName, SkipTaskRequest skipTaskRequest) {
        this.workflowService.skipTaskFromWorkflow(workflowId, taskReferenceName, skipTaskRequest);
    }

    @POST
    @Path(value="/{workflowId}/rerun")
    @ApiOperation(value="Reruns the workflow from a specific task")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain", "application/json"})
    public String rerun(@PathParam(value="workflowId") String workflowId, RerunWorkflowRequest request) {
        return this.workflowService.rerunWorkflow(workflowId, request);
    }

    @POST
    @Path(value="/{workflowId}/restart")
    @ApiOperation(value="Restarts a completed workflow")
    @Consumes(value={"*/*"})
    public void restart(@PathParam(value="workflowId") String workflowId, @QueryParam(value="useLatestDefinitions") @DefaultValue(value="false") boolean useLatestDefinitions) {
        this.workflowService.restartWorkflow(workflowId, useLatestDefinitions);
    }

    @POST
    @Path(value="/{workflowId}/retry")
    @ApiOperation(value="Retries the last failed task")
    @Consumes(value={"*/*"})
    public void retry(@PathParam(value="workflowId") String workflowId, @QueryParam(value="resumeSubworkflowTasks") @DefaultValue(value="false") boolean resumeSubworkflowTasks) {
        this.workflowService.retryWorkflow(workflowId, resumeSubworkflowTasks);
    }

    @POST
    @Path(value="/{workflowId}/resetcallbacks")
    @ApiOperation(value="Resets callback times of all non-terminal SIMPLE tasks to 0")
    @Consumes(value={"*/*"})
    public void resetWorkflow(@PathParam(value="workflowId") String workflowId) {
        this.workflowService.resetWorkflow(workflowId);
    }

    @DELETE
    @Path(value="/{workflowId}")
    @ApiOperation(value="Terminate workflow execution")
    @Consumes(value={"*/*"})
    public void terminate(@PathParam(value="workflowId") String workflowId, @QueryParam(value="reason") String reason) {
        this.workflowService.terminateWorkflow(workflowId, reason);
    }

    @ApiOperation(value="Search for workflows based on payload and other parameters", notes="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC.")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public SearchResult<WorkflowSummary> search(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="size") @DefaultValue(value="100") int size, @QueryParam(value="sort") String sort, @QueryParam(value="freeText") @DefaultValue(value="*") String freeText, @QueryParam(value="query") String query) {
        return this.workflowService.searchWorkflows(start, size, sort, freeText, query);
    }

    @ApiOperation(value="Search for workflows based on task parameters", notes="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/search-by-tasks")
    public SearchResult<WorkflowSummary> searchWorkflowsByTasks(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="size") @DefaultValue(value="100") int size, @QueryParam(value="sort") String sort, @QueryParam(value="freeText") @DefaultValue(value="*") String freeText, @QueryParam(value="query") String query) {
        return this.workflowService.searchWorkflowsByTasks(start, size, sort, freeText, query);
    }

    @ApiOperation(value="Search for workflows based on payload and other parameters", notes="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC.")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/search-v2")
    public SearchResult<Workflow> searchV2(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="size") @DefaultValue(value="100") int size, @QueryParam(value="sort") String sort, @QueryParam(value="freeText") @DefaultValue(value="*") String freeText, @QueryParam(value="query") String query) {
        return this.workflowService.searchWorkflowsV2(start, size, sort, freeText, query);
    }

    @ApiOperation(value="Search for workflows based on task parameters", notes="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/search-by-tasks-v2")
    public SearchResult<Workflow> searchWorkflowsByTasksV2(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="size") @DefaultValue(value="100") int size, @QueryParam(value="sort") String sort, @QueryParam(value="freeText") @DefaultValue(value="*") String freeText, @QueryParam(value="query") String query) {
        return this.workflowService.searchWorkflowsByTasksV2(start, size, sort, freeText, query);
    }

    @GET
    @ApiOperation(value="Get the uri and path of the external storage where the workflow payload is to be stored")
    @Consumes(value={"*/*"})
    @Path(value="/externalstoragelocation")
    public ExternalStorageLocation getExternalStorageLocation(@QueryParam(value="path") String path, @QueryParam(value="operation") String operation, @QueryParam(value="payloadType") String payloadType) {
        return this.workflowService.getExternalStorageLocation(path, operation, payloadType);
    }
}

