/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.tasks.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.netflix.conductor.core.execution.WorkflowExecutor;
import com.netflix.conductor.core.execution.tasks.WorkflowSystemTask;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.model.WorkflowModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="JSON_JQ_TRANSFORM")
public class JsonJqTransform
extends WorkflowSystemTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonJqTransform.class);
    public static final String NAME = "JSON_JQ_TRANSFORM";
    private static final String QUERY_EXPRESSION_PARAMETER = "queryExpression";
    private static final String OUTPUT_RESULT = "result";
    private static final String OUTPUT_RESULT_LIST = "resultList";
    private static final String OUTPUT_ERROR = "error";
    private static final TypeReference<Map<String, Object>> mapType = new TypeReference<Map<String, Object>>(){};
    private final TypeReference<List<Object>> listType = new TypeReference<List<Object>>(){};
    private final Scope rootScope;
    private final ObjectMapper objectMapper;
    private final LoadingCache<String, JsonQuery> queryCache = this.createQueryCache();

    @Autowired
    public JsonJqTransform(ObjectMapper objectMapper) {
        super(NAME);
        this.objectMapper = objectMapper;
        this.rootScope = Scope.newEmptyScope();
        this.rootScope.loadFunctions(Scope.class.getClassLoader());
    }

    public void start(WorkflowModel workflow, TaskModel task, WorkflowExecutor executor) {
        Map taskInput = task.getInputData();
        String queryExpression = (String)taskInput.get(QUERY_EXPRESSION_PARAMETER);
        if (queryExpression == null) {
            task.setReasonForIncompletion("Missing 'queryExpression' in input parameters");
            task.setStatus(TaskModel.Status.FAILED);
            return;
        }
        try {
            JsonNode input = this.objectMapper.valueToTree((Object)taskInput);
            JsonQuery query = (JsonQuery)this.queryCache.get((Object)queryExpression);
            Scope childScope = Scope.newChildScope((Scope)this.rootScope);
            List result = query.apply(childScope, input);
            task.setStatus(TaskModel.Status.COMPLETED);
            if (result == null) {
                task.addOutput(OUTPUT_RESULT, null);
                task.addOutput(OUTPUT_RESULT_LIST, null);
            } else if (result.isEmpty()) {
                task.addOutput(OUTPUT_RESULT, null);
                task.addOutput(OUTPUT_RESULT_LIST, (Object)result);
            } else {
                task.addOutput(OUTPUT_RESULT, this.extractBody((JsonNode)result.get(0)));
                task.addOutput(OUTPUT_RESULT_LIST, (Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing task: {} in workflow: {}", new Object[]{task.getTaskId(), workflow.getWorkflowId(), e});
            task.setStatus(TaskModel.Status.FAILED);
            String message = this.extractFirstValidMessage(e);
            task.setReasonForIncompletion(message);
            task.addOutput(OUTPUT_ERROR, (Object)message);
        }
    }

    private LoadingCache<String, JsonQuery> createQueryCache() {
        CacheLoader loader = JsonQuery::compile;
        return Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(1000L).build(loader);
    }

    private String extractFirstValidMessage(Exception e) {
        Throwable currentStack = e;
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(currentStack.getMessage());
        while (currentStack.getCause() != null) {
            currentStack = currentStack.getCause();
            messages.add(currentStack.getMessage());
        }
        return messages.stream().filter(it -> !it.contains("N/A")).findFirst().orElse("");
    }

    private Object extractBody(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            return this.objectMapper.convertValue((Object)node, mapType);
        }
        if (node.isArray()) {
            return this.objectMapper.convertValue((Object)node, this.listType);
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isNumber()) {
            if (node.isIntegralNumber()) {
                return node.asLong();
            }
            return node.asDouble();
        }
        return node.asText();
    }
}

