/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.core.execution.mapper;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.core.exception.TerminateWorkflowException;
import com.netflix.conductor.core.execution.mapper.TaskMapper;
import com.netflix.conductor.core.execution.mapper.TaskMapperContext;
import com.netflix.conductor.core.utils.ParametersUtils;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.model.WorkflowModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KafkaPublishTaskMapper
implements TaskMapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(KafkaPublishTaskMapper.class);
    private final ParametersUtils parametersUtils;
    private final MetadataDAO metadataDAO;

    @Autowired
    public KafkaPublishTaskMapper(ParametersUtils parametersUtils, MetadataDAO metadataDAO) {
        this.parametersUtils = parametersUtils;
        this.metadataDAO = metadataDAO;
    }

    public String getTaskType() {
        return TaskType.KAFKA_PUBLISH.name();
    }

    public List<TaskModel> getMappedTasks(TaskMapperContext taskMapperContext) throws TerminateWorkflowException {
        LOGGER.debug("TaskMapperContext {} in KafkaPublishTaskMapper", (Object)taskMapperContext);
        WorkflowTask workflowTask = taskMapperContext.getWorkflowTask();
        WorkflowModel workflowModel = taskMapperContext.getWorkflowModel();
        String taskId = taskMapperContext.getTaskId();
        int retryCount = taskMapperContext.getRetryCount();
        TaskDef taskDefinition = Optional.ofNullable(taskMapperContext.getTaskDefinition()).orElseGet(() -> this.metadataDAO.getTaskDef(workflowTask.getName()));
        Map input = this.parametersUtils.getTaskInputV2(workflowTask.getInputParameters(), workflowModel, taskId, taskDefinition);
        TaskModel kafkaPublishTask = taskMapperContext.createTaskModel();
        kafkaPublishTask.setInputData(input);
        kafkaPublishTask.setStatus(TaskModel.Status.SCHEDULED);
        kafkaPublishTask.setRetryCount(retryCount);
        kafkaPublishTask.setCallbackAfterSeconds((long)workflowTask.getStartDelay());
        if (Objects.nonNull(taskDefinition)) {
            kafkaPublishTask.setExecutionNameSpace(taskDefinition.getExecutionNameSpace());
            kafkaPublishTask.setIsolationGroupId(taskDefinition.getIsolationGroupId());
            kafkaPublishTask.setRateLimitPerFrequency(taskDefinition.getRateLimitPerFrequency().intValue());
            kafkaPublishTask.setRateLimitFrequencyInSeconds(taskDefinition.getRateLimitFrequencyInSeconds().intValue());
        }
        return Collections.singletonList(kafkaPublishTask);
    }
}

