/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"conductor.metrics-logger.enabled"}, havingValue="true")
@Configuration
public class LoggingMetricsConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingMetricsConfiguration.class);
    private static final Logger METRICS_LOGGER = LoggerFactory.getLogger((String)"ConductorMetrics");
    @Value(value="${conductor.metrics-logger.reportInterval:#{T(java.time.Duration).ofSeconds(30)}}")
    private Duration reportInterval;

    @Bean
    public Slf4jReporter getSl4jReporter(MetricRegistry metricRegistry) {
        return new Slf4jReporterProvider(metricRegistry, this.reportInterval.getSeconds()).getReporter();
    }

    static class Slf4jReporterProvider {
        private final long metricsReportInterval;
        private final MetricRegistry metrics3Registry;
        private final Logger logger;

        Slf4jReporterProvider(MetricRegistry metricRegistry, long reportInterval) {
            this(metricRegistry, METRICS_LOGGER, reportInterval);
        }

        Slf4jReporterProvider(MetricRegistry metricRegistry, Logger outputLogger, long metricsReportInterval) {
            this.metrics3Registry = metricRegistry;
            this.logger = outputLogger;
            this.metricsReportInterval = metricsReportInterval;
        }

        public Slf4jReporter getReporter() {
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metrics3Registry).outputTo(this.logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start(this.metricsReportInterval, TimeUnit.SECONDS);
            LOGGER.info("Logging metrics reporter started, reporting every {} seconds", (Object)this.metricsReportInterval);
            return reporter;
        }
    }
}

