/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.metrics;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.micrometer.MicrometerRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusRenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"conductor.metrics-prometheus.enabled"}, havingValue="true")
@Configuration
public class PrometheusMetricsConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusMetricsConfiguration.class);

    public PrometheusMetricsConfiguration(MeterRegistry meterRegistry) {
        LOGGER.info("Prometheus metrics module initialized");
        MicrometerRegistry metricsRegistry = new MicrometerRegistry(meterRegistry);
        meterRegistry.config().meterFilter((MeterFilter)new PrometheusRenameFilter());
        Spectator.globalRegistry().add((Registry)metricsRegistry);
    }
}

