/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.dao.mysql.MySQLBaseDAO;
import com.netflix.conductor.metrics.Monitors;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.sql.DataSource;

public class MySQLMetadataDAO
extends MySQLBaseDAO
implements MetadataDAO {
    public static final String PROP_TASKDEF_CACHE_REFRESH = "conductor.taskdef.cache.refresh.time.seconds";
    public static final int DEFAULT_TASKDEF_CACHE_REFRESH_SECONDS = 60;
    private final ConcurrentHashMap<String, TaskDef> taskDefCache = new ConcurrentHashMap();
    private static final String className = MySQLMetadataDAO.class.getSimpleName();

    @Inject
    public MySQLMetadataDAO(ObjectMapper om, DataSource dataSource, Configuration config) {
        super(om, dataSource);
        int cacheRefreshTime = config.getIntProperty(PROP_TASKDEF_CACHE_REFRESH, 60);
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::refreshTaskDefs, cacheRefreshTime, cacheRefreshTime, TimeUnit.SECONDS);
    }

    public String createTaskDef(TaskDef taskDef) {
        this.validate(taskDef);
        if (null == taskDef.getCreateTime() || taskDef.getCreateTime() < 1L) {
            taskDef.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        }
        return this.insertOrUpdateTaskDef(taskDef);
    }

    public String updateTaskDef(TaskDef taskDef) {
        this.validate(taskDef);
        taskDef.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        return this.insertOrUpdateTaskDef(taskDef);
    }

    public TaskDef getTaskDef(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"TaskDef name cannot be null");
        TaskDef taskDef = this.taskDefCache.get(name);
        if (taskDef == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Cache miss: {}", (Object)name);
            }
            taskDef = this.getTaskDefFromDB(name);
        }
        return taskDef;
    }

    public List<TaskDef> getAllTaskDefs() {
        return this.getWithTransaction(this::findAllTaskDefs);
    }

    public void removeTaskDef(String name) {
        String DELETE_TASKDEF_QUERY = "DELETE FROM meta_task_def WHERE name = ?";
        this.executeWithTransaction("DELETE FROM meta_task_def WHERE name = ?", q -> {
            if (!q.addParameter(name).executeDelete()) {
                throw new ApplicationException(ApplicationException.Code.NOT_FOUND, "No such task definition");
            }
            this.taskDefCache.remove(name);
        });
    }

    public void create(WorkflowDef def) {
        this.validate(def);
        if (null == def.getCreateTime() || def.getCreateTime() == 0L) {
            def.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        }
        this.withTransaction(tx -> {
            if (this.workflowExists((Connection)tx, def).booleanValue()) {
                throw new ApplicationException(ApplicationException.Code.CONFLICT, "Workflow with " + def.key() + " already exists!");
            }
            this.insertOrUpdateWorkflowDef((Connection)tx, def);
        });
    }

    public void update(WorkflowDef def) {
        this.validate(def);
        def.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.withTransaction(tx -> this.insertOrUpdateWorkflowDef((Connection)tx, def));
    }

    public WorkflowDef getLatest(String name) {
        String GET_LATEST_WORKFLOW_DEF_QUERY = "SELECT json_data FROM meta_workflow_def WHERE NAME = ? AND version = latest_version";
        return this.queryWithTransaction("SELECT json_data FROM meta_workflow_def WHERE NAME = ? AND version = latest_version", q -> q.addParameter(name).executeAndFetchFirst(WorkflowDef.class));
    }

    public WorkflowDef get(String name, int version) {
        String GET_WORKFLOW_DEF_QUERY = "SELECT json_data FROM meta_workflow_def WHERE NAME = ? AND version = ?";
        return this.queryWithTransaction("SELECT json_data FROM meta_workflow_def WHERE NAME = ? AND version = ?", q -> q.addParameter(name).addParameter(version).executeAndFetchFirst(WorkflowDef.class));
    }

    public void removeWorkflowDef(String name, Integer version) {
        String DELETE_WORKFLOW_QUERY = "DELETE from meta_workflow_def WHERE name = ? AND version = ?";
        this.executeWithTransaction("DELETE from meta_workflow_def WHERE name = ? AND version = ?", q -> {
            if (!q.addParameter(name).addParameter(version).executeDelete()) {
                throw new ApplicationException(ApplicationException.Code.NOT_FOUND, String.format("No such workflow definition: %s version: %d", name, version));
            }
        });
    }

    public List<String> findAll() {
        String FIND_ALL_WORKFLOW_DEF_QUERY = "SELECT DISTINCT name FROM meta_workflow_def";
        return this.queryWithTransaction("SELECT DISTINCT name FROM meta_workflow_def", q -> q.executeAndFetch(String.class));
    }

    public List<WorkflowDef> getAll() {
        String GET_ALL_WORKFLOW_DEF_QUERY = "SELECT json_data FROM meta_workflow_def ORDER BY name, version";
        return this.queryWithTransaction("SELECT json_data FROM meta_workflow_def ORDER BY name, version", q -> q.executeAndFetch(WorkflowDef.class));
    }

    public List<WorkflowDef> getAllLatest() {
        String GET_ALL_LATEST_WORKFLOW_DEF_QUERY = "SELECT json_data FROM meta_workflow_def WHERE version = latest_version";
        return this.queryWithTransaction("SELECT json_data FROM meta_workflow_def WHERE version = latest_version", q -> q.executeAndFetch(WorkflowDef.class));
    }

    public List<WorkflowDef> getAllVersions(String name) {
        String GET_ALL_VERSIONS_WORKFLOW_DEF_QUERY = "SELECT json_data FROM meta_workflow_def WHERE name = ? ORDER BY version";
        return this.queryWithTransaction("SELECT json_data FROM meta_workflow_def WHERE name = ? ORDER BY version", q -> q.addParameter(name).executeAndFetch(WorkflowDef.class));
    }

    public void addEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler.getName(), (Object)"EventHandler name cannot be null");
        String INSERT_EVENT_HANDLER_QUERY = "INSERT INTO meta_event_handler (name, event, active, json_data) VALUES (?, ?, ?, ?)";
        this.withTransaction(tx -> {
            if (this.getEventHandler((Connection)tx, eventHandler.getName()) != null) {
                throw new ApplicationException(ApplicationException.Code.CONFLICT, "EventHandler with name " + eventHandler.getName() + " already exists!");
            }
            this.execute((Connection)tx, "INSERT INTO meta_event_handler (name, event, active, json_data) VALUES (?, ?, ?, ?)", q -> q.addParameter(eventHandler.getName()).addParameter(eventHandler.getEvent()).addParameter(eventHandler.isActive()).addJsonParameter(eventHandler).executeUpdate());
        });
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler.getName(), (Object)"EventHandler name cannot be null");
        String UPDATE_EVENT_HANDLER_QUERY = "UPDATE meta_event_handler SET event = ?, active = ?, json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE name = ?";
        this.withTransaction(tx -> {
            EventHandler existing = this.getEventHandler((Connection)tx, eventHandler.getName());
            if (existing == null) {
                throw new ApplicationException(ApplicationException.Code.NOT_FOUND, "EventHandler with name " + eventHandler.getName() + " not found!");
            }
            this.execute((Connection)tx, "UPDATE meta_event_handler SET event = ?, active = ?, json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE name = ?", q -> q.addParameter(eventHandler.getEvent()).addParameter(eventHandler.isActive()).addJsonParameter(eventHandler).addParameter(eventHandler.getName()).executeUpdate());
        });
    }

    public void removeEventHandlerStatus(String name) {
        String DELETE_EVENT_HANDLER_QUERY = "DELETE FROM meta_event_handler WHERE name = ?";
        this.withTransaction(tx -> {
            EventHandler existing = this.getEventHandler((Connection)tx, name);
            if (existing == null) {
                throw new ApplicationException(ApplicationException.Code.NOT_FOUND, "EventHandler with name " + name + " not found!");
            }
            this.execute((Connection)tx, "DELETE FROM meta_event_handler WHERE name = ?", q -> q.addParameter(name).executeDelete());
        });
    }

    public List<EventHandler> getEventHandlers() {
        String READ_ALL_EVENT_HANDLER_QUERY = "SELECT json_data FROM meta_event_handler";
        return this.queryWithTransaction("SELECT json_data FROM meta_event_handler", q -> q.executeAndFetch(EventHandler.class));
    }

    public List<EventHandler> getEventHandlersForEvent(String event, boolean activeOnly) {
        String READ_ALL_EVENT_HANDLER_BY_EVENT_QUERY = "SELECT json_data FROM meta_event_handler WHERE event = ?";
        return this.queryWithTransaction("SELECT json_data FROM meta_event_handler WHERE event = ?", q -> {
            q.addParameter(event);
            return q.executeAndFetch(rs -> {
                ArrayList<EventHandler> handlers = new ArrayList<EventHandler>();
                while (rs.next()) {
                    EventHandler h = this.readValue(rs.getString(1), EventHandler.class);
                    if (activeOnly && !h.isActive()) continue;
                    handlers.add(h);
                }
                return handlers;
            });
        });
    }

    private void validate(TaskDef taskDef) {
        Preconditions.checkNotNull((Object)taskDef, (Object)"TaskDef object cannot be null");
        Preconditions.checkNotNull((Object)taskDef.getName(), (Object)"TaskDef name cannot be null");
    }

    private void validate(WorkflowDef def) {
        Preconditions.checkNotNull((Object)def, (Object)"WorkflowDef object cannot be null");
        Preconditions.checkNotNull((Object)def.getName(), (Object)"WorkflowDef name cannot be null");
    }

    private EventHandler getEventHandler(Connection connection, String name) {
        String READ_ONE_EVENT_HANDLER_QUERY = "SELECT json_data FROM meta_event_handler WHERE name = ?";
        return this.query(connection, "SELECT json_data FROM meta_event_handler WHERE name = ?", q -> q.addParameter(name).executeAndFetchFirst(EventHandler.class));
    }

    private Boolean workflowExists(Connection connection, WorkflowDef def) {
        String CHECK_WORKFLOW_DEF_EXISTS_QUERY = "SELECT COUNT(*) FROM meta_workflow_def WHERE name = ? AND version = ?";
        return this.query(connection, "SELECT COUNT(*) FROM meta_workflow_def WHERE name = ? AND version = ?", q -> q.addParameter(def.getName()).addParameter(def.getVersion()).exists());
    }

    private Optional<Integer> getLatestVersion(Connection tx, WorkflowDef def) {
        String GET_LATEST_WORKFLOW_DEF_VERSION = "SELECT max(version) AS version FROM meta_workflow_def WHERE name = ?";
        Integer val = this.query(tx, "SELECT max(version) AS version FROM meta_workflow_def WHERE name = ?", q -> {
            q.addParameter(def.getName());
            return q.executeAndFetch(rs -> {
                if (!rs.next()) {
                    return null;
                }
                return rs.getInt(1);
            });
        });
        return Optional.ofNullable(val);
    }

    private void updateLatestVersion(Connection tx, WorkflowDef def) {
        String UPDATE_WORKFLOW_DEF_LATEST_VERSION_QUERY = "UPDATE meta_workflow_def SET latest_version = ? WHERE name = ?";
        this.execute(tx, "UPDATE meta_workflow_def SET latest_version = ? WHERE name = ?", q -> q.addParameter(def.getVersion()).addParameter(def.getName()).executeUpdate());
    }

    private void insertOrUpdateWorkflowDef(Connection tx, WorkflowDef def) {
        String INSERT_WORKFLOW_DEF_QUERY = "INSERT INTO meta_workflow_def (name, version, json_data) VALUES (?, ?, ?)";
        Optional<Integer> version = this.getLatestVersion(tx, def);
        if (!version.isPresent() || version.get() < def.getVersion()) {
            this.execute(tx, "INSERT INTO meta_workflow_def (name, version, json_data) VALUES (?, ?, ?)", q -> q.addParameter(def.getName()).addParameter(def.getVersion()).addJsonParameter(def).executeUpdate());
        } else {
            String UPDATE_WORKFLOW_DEF_QUERY = "UPDATE meta_workflow_def SET json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE name = ? AND version = ?";
            this.execute(tx, "UPDATE meta_workflow_def SET json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE name = ? AND version = ?", q -> q.addJsonParameter(def).addParameter(def.getName()).addParameter(def.getVersion()).executeUpdate());
        }
        this.updateLatestVersion(tx, def);
    }

    private void refreshTaskDefs() {
        try {
            this.withTransaction(tx -> {
                HashMap map = new HashMap();
                this.findAllTaskDefs((Connection)tx).forEach(taskDef -> map.put(taskDef.getName(), taskDef));
                ConcurrentHashMap<String, TaskDef> concurrentHashMap = this.taskDefCache;
                synchronized (concurrentHashMap) {
                    this.taskDefCache.clear();
                    this.taskDefCache.putAll(map);
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Refreshed {} TaskDefs", (Object)this.taskDefCache.size());
                }
            });
        }
        catch (Exception e) {
            Monitors.error((String)className, (String)"refreshTaskDefs");
            this.logger.error("refresh TaskDefs failed ", (Throwable)e);
        }
    }

    private List<TaskDef> findAllTaskDefs(Connection tx) {
        String READ_ALL_TASKDEF_QUERY = "SELECT json_data FROM meta_task_def";
        return this.query(tx, "SELECT json_data FROM meta_task_def", q -> q.executeAndFetch(TaskDef.class));
    }

    private TaskDef getTaskDefFromDB(String name) {
        String READ_ONE_TASKDEF_QUERY = "SELECT json_data FROM meta_task_def WHERE name = ?";
        return this.queryWithTransaction("SELECT json_data FROM meta_task_def WHERE name = ?", q -> q.addParameter(name).executeAndFetchFirst(TaskDef.class));
    }

    private String insertOrUpdateTaskDef(TaskDef taskDef) {
        String UPDATE_TASKDEF_QUERY = "UPDATE meta_task_def SET json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE name = ?";
        String INSERT_TASKDEF_QUERY = "INSERT INTO meta_task_def (name, json_data) VALUES (?, ?)";
        return this.getWithTransaction(tx -> {
            this.execute(tx, "UPDATE meta_task_def SET json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE name = ?", update -> {
                int result = update.addJsonParameter(taskDef).addParameter(taskDef.getName()).executeUpdate();
                if (result == 0) {
                    this.execute(tx, "INSERT INTO meta_task_def (name, json_data) VALUES (?, ?)", insert -> insert.addParameter(taskDef.getName()).addJsonParameter(taskDef).executeUpdate());
                }
            });
            this.taskDefCache.put(taskDef.getName(), taskDef);
            return taskDef.getName();
        });
    }
}

