/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.mysql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.dao.mysql.ResultSetHandler;
import java.io.IOException;
import java.lang.constant.Constable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper om;
    private final String rawQuery;
    private final AtomicInteger index = new AtomicInteger(1);
    private final PreparedStatement statement;

    public Query(ObjectMapper objectMapper, Connection connection, String query) {
        this.rawQuery = query;
        this.om = objectMapper;
        try {
            this.statement = connection.prepareStatement(query);
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Cannot prepare statement for query: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static String generateInBindings(int count) {
        CharSequence[] questions = new String[count];
        for (int i = 0; i < count; ++i) {
            questions[i] = "?";
        }
        return String.join((CharSequence)", ", questions);
    }

    public Query addParameter(String value) {
        return this.addParameterInternal((ps, idx) -> ps.setString(idx, value));
    }

    public Query addParameter(int value) {
        return this.addParameterInternal((ps, idx) -> ps.setInt(idx, value));
    }

    public Query addParameter(boolean value) {
        return this.addParameterInternal((ps, idx) -> ps.setBoolean(idx, value));
    }

    public Query addParameter(long value) {
        return this.addParameterInternal((ps, idx) -> ps.setLong(idx, value));
    }

    public Query addParameter(double value) {
        return this.addParameterInternal((ps, idx) -> ps.setDouble(idx, value));
    }

    public Query addParameter(Date date) {
        return this.addParameterInternal((ps, idx) -> ps.setDate(idx, date));
    }

    public Query addParameter(Timestamp timestamp) {
        return this.addParameterInternal((ps, idx) -> ps.setTimestamp(idx, timestamp));
    }

    public Query addJsonParameter(Object value) {
        return this.addParameter(this.toJson(value));
    }

    public Query addDateParameter(java.util.Date date) {
        return this.addParameter(new Date(date.getTime()));
    }

    public Query addTimestampParameter(java.util.Date date) {
        return this.addParameter(new Timestamp(date.getTime()));
    }

    public Query addTimestampParameter(long epochMillis) {
        return this.addParameter(new Timestamp(epochMillis));
    }

    public Query addParameters(Collection values) {
        return this.addParameters(values.toArray());
    }

    public Query addParameters(Object ... values) {
        for (Object v : values) {
            if (v instanceof String) {
                this.addParameter((String)v);
                continue;
            }
            if (v instanceof Integer) {
                this.addParameter((Integer)v);
                continue;
            }
            if (v instanceof Long) {
                this.addParameter((Long)v);
                continue;
            }
            if (v instanceof Double) {
                this.addParameter((Double)v);
                continue;
            }
            if (v instanceof Boolean) {
                this.addParameter((Boolean)v);
                continue;
            }
            if (v instanceof Date) {
                this.addParameter((Date)v);
                continue;
            }
            if (v instanceof Timestamp) {
                this.addParameter((Timestamp)v);
                continue;
            }
            throw new IllegalArgumentException("Type " + v.getClass().getName() + " is not supported by automatic property assignment");
        }
        return this;
    }

    public boolean exists() {
        Object val = this.executeScalar();
        if (null == val) {
            return false;
        }
        if (val instanceof Number) {
            return this.convertLong(val) > 0L;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return this.convertBoolean(val);
        }
        throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Expected a Numeric or Boolean scalar return value from the query, received " + val.getClass().getName());
    }

    public boolean executeDelete() {
        int count = this.executeUpdate();
        if (count > 1) {
            this.logger.debug("Removed {} row(s) for query {}", (Object)count, (Object)this.rawQuery);
        }
        return count > 0;
    }

    public long executeCount() {
        return this.executeScalar(Long.class);
    }

    public int executeUpdate() {
        try {
            Long start = null;
            if (this.logger.isTraceEnabled()) {
                start = System.currentTimeMillis();
            }
            int val = this.statement.executeUpdate();
            if (null != start && this.logger.isTraceEnabled()) {
                long end = System.currentTimeMillis();
                this.logger.trace("[{}ms] {}: {}", new Object[]{end - start, val, this.rawQuery});
            }
            return val;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, ex.getMessage());
        }
    }

    public ResultSet executeQuery() {
        Long start = null;
        if (this.logger.isTraceEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            ResultSet resultSet = this.statement.executeQuery();
            return resultSet;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
        finally {
            if (null != start && this.logger.isTraceEnabled()) {
                long end = System.currentTimeMillis();
                this.logger.trace("[{}ms] {}", (Object)(end - start), (Object)this.rawQuery);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeScalar() {
        try (ResultSet rs = this.executeQuery();){
            if (!rs.next()) {
                Object var3_4 = null;
                return var3_4;
            }
            Object object = rs.getObject(1);
            return object;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V> V executeScalar(Class<V> returnType) {
        try (ResultSet rs = this.executeQuery();){
            if (!rs.next()) {
                Constable value = null;
                if (Integer.class == returnType) {
                    value = 0;
                } else if (Long.class == returnType) {
                    value = 0L;
                } else if (Boolean.class == returnType) {
                    value = Boolean.valueOf(false);
                }
                V v = returnType.cast(value);
                return v;
            }
            V v = this.getScalarFromResultSet(rs, returnType);
            return v;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V> List<V> executeScalarList(Class<V> returnType) {
        try (ResultSet rs = this.executeQuery();){
            ArrayList<V> values = new ArrayList<V>();
            while (rs.next()) {
                values.add(this.getScalarFromResultSet(rs, returnType));
            }
            ArrayList<V> arrayList = values;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    public <V> V executeAndFetchFirst(Class<V> returnType) {
        Object o = this.executeScalar();
        if (null == o) {
            return null;
        }
        return this.convert(o, returnType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V> List<V> executeAndFetch(Class<V> returnType) {
        try (ResultSet rs = this.executeQuery();){
            ArrayList<V> list = new ArrayList<V>();
            while (rs.next()) {
                list.add(this.convert(rs.getObject(1), returnType));
            }
            ArrayList<V> arrayList = list;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V> V executeAndFetch(ResultSetHandler<V> handler) {
        try (ResultSet rs = this.executeQuery();){
            V v = handler.apply(rs);
            return v;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            if (null != this.statement && !this.statement.isClosed()) {
                this.statement.close();
            }
        }
        catch (SQLException ex) {
            this.logger.warn("Error closing prepared statement: {}", (Object)ex.getMessage());
        }
    }

    protected final Query addParameterInternal(InternalParameterSetter setter) {
        int index = this.getAndIncrementIndex();
        try {
            setter.apply(this.statement, index);
            return this;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Could not apply bind parameter at index " + index, (Throwable)ex);
        }
    }

    protected <V> V getScalarFromResultSet(ResultSet rs, Class<V> returnType) throws SQLException {
        Object value = null;
        value = Integer.class == returnType ? Integer.valueOf(rs.getInt(1)) : (Long.class == returnType ? Long.valueOf(rs.getLong(1)) : (String.class == returnType ? rs.getString(1) : (Boolean.class == returnType ? Boolean.valueOf(rs.getBoolean(1)) : (Double.class == returnType ? Double.valueOf(rs.getDouble(1)) : (Date.class == returnType ? rs.getDate(1) : (Timestamp.class == returnType ? rs.getTimestamp(1) : rs.getObject(1)))))));
        if (null == value) {
            throw new NullPointerException("Cannot get value from ResultSet of type " + returnType.getName());
        }
        return returnType.cast(value);
    }

    protected <V> V convert(Object value, Class<V> returnType) {
        if (Boolean.class == returnType) {
            return returnType.cast(this.convertBoolean(value));
        }
        if (Integer.class == returnType) {
            return returnType.cast(this.convertInt(value));
        }
        if (Long.class == returnType) {
            return returnType.cast(this.convertLong(value));
        }
        if (Double.class == returnType) {
            return returnType.cast(this.convertDouble(value));
        }
        if (String.class == returnType) {
            return returnType.cast(this.convertString(value));
        }
        if (value instanceof String) {
            return this.fromJson((String)value, returnType);
        }
        String vName = value.getClass().getName();
        String rName = returnType.getName();
        throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Cannot convert type " + vName + " to " + rName);
    }

    protected Integer convertInt(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return NumberUtils.toInt((String)value.toString());
    }

    protected Double convertDouble(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return NumberUtils.toDouble((String)value.toString());
    }

    protected Long convertLong(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return NumberUtils.toLong((String)value.toString());
    }

    protected String convertString(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString().trim();
    }

    protected Boolean convertBoolean(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        String text = value.toString().trim();
        return "Y".equalsIgnoreCase(text) || "YES".equalsIgnoreCase(text) || "TRUE".equalsIgnoreCase(text) || "T".equalsIgnoreCase(text) || "1".equalsIgnoreCase(text);
    }

    protected String toJson(Object value) {
        if (null == value) {
            return null;
        }
        try {
            return this.om.writeValueAsString(value);
        }
        catch (JsonProcessingException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    protected <V> V fromJson(String value, Class<V> returnType) {
        if (null == value) {
            return null;
        }
        try {
            return (V)this.om.readValue(value, returnType);
        }
        catch (IOException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Could not convert JSON '" + value + "' to " + returnType.getName(), (Throwable)ex);
        }
    }

    protected final int getIndex() {
        return this.index.get();
    }

    protected final int getAndIncrementIndex() {
        return this.index.getAndIncrement();
    }

    @FunctionalInterface
    private static interface InternalParameterSetter {
        public void apply(PreparedStatement var1, int var2) throws SQLException;
    }
}

