/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.conductor.common.metadata.events.EventExecution;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.core.events.queue.Message;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.dao.ExecutionDAO;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.dao.mysql.MySQLBaseDAO;
import com.netflix.conductor.metrics.Monitors;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.sql2o.Connection;
import org.sql2o.ResultSetHandler;
import org.sql2o.Sql2o;

class MySQLExecutionDAO
extends MySQLBaseDAO
implements ExecutionDAO {
    private static final String ARCHIVED_FIELD = "archived";
    private static final String RAW_JSON_FIELD = "rawJSON";
    private IndexDAO indexer;
    private MetadataDAO metadata;

    @Inject
    MySQLExecutionDAO(IndexDAO indexer, MetadataDAO metadata, ObjectMapper om, Sql2o sql2o) {
        super(om, sql2o);
        this.indexer = indexer;
        this.metadata = metadata;
    }

    public List<Task> getPendingTasksByWorkflow(String taskDefName, String workflowId) {
        return this.getWithTransaction(connection -> {
            String GET_IN_PROGRESS_TASKS_FOR_WORKFLOW = "SELECT json_data FROM task_in_progress tip INNER JOIN task t ON t.task_id = tip.task_id \n WHERE task_def_name = :taskDefName AND workflow_id = :workflowId";
            ResultSetHandler resultSetHandler = resultSet -> this.readValue(resultSet.getString("json_data"), Task.class);
            return connection.createQuery(GET_IN_PROGRESS_TASKS_FOR_WORKFLOW).addParameter("taskDefName", taskDefName).addParameter("workflowId", workflowId).executeAndFetch(resultSetHandler);
        });
    }

    public List<Task> getTasks(String taskDefName, String startKey, int count) {
        ArrayList<Task> tasks = new ArrayList<Task>(count);
        List<Task> pendingTasks = this.getPendingTasksForTaskType(taskDefName);
        boolean startKeyFound = startKey == null;
        int found = 0;
        for (Task pendingTask : pendingTasks) {
            if (!startKeyFound && pendingTask.getTaskId().equals(startKey)) {
                startKeyFound = true;
                if (startKey != null) continue;
            }
            if (!startKeyFound || found >= count) continue;
            tasks.add(pendingTask);
            ++found;
        }
        return tasks;
    }

    public List<Task> createTasks(List<Task> tasks) {
        LinkedList created = Lists.newLinkedList();
        this.withTransaction(connection -> {
            for (Task task : tasks) {
                this.validate(task);
                task.setScheduledTime(System.currentTimeMillis());
                String taskKey = task.getReferenceTaskName() + "_" + task.getRetryCount();
                boolean scheduledTaskAdded = this.addScheduledTask((Connection)connection, task, taskKey);
                if (!scheduledTaskAdded) {
                    this.logger.info("Task already scheduled, skipping the run " + task.getTaskId() + ", ref=" + task.getReferenceTaskName() + ", key=" + taskKey);
                    continue;
                }
                this.insertOrUpdateTaskData((Connection)connection, task);
                this.addWorkflowToTaskMapping((Connection)connection, task);
                this.addTaskInProgress((Connection)connection, task);
                this.updateTask((Connection)connection, task);
                created.add(task);
            }
        });
        return created;
    }

    public void updateTask(Task task) {
        this.withTransaction(connection -> this.updateTask((Connection)connection, task));
    }

    public boolean exceedsInProgressLimit(Task task) {
        boolean rateLimited;
        TaskDef taskDef = this.metadata.getTaskDef(task.getTaskDefName());
        if (taskDef == null) {
            return false;
        }
        int limit = taskDef.concurrencyLimit();
        if (limit <= 0) {
            return false;
        }
        long current = this.getInProgressTaskCount(task.getTaskDefName());
        if (current >= (long)limit) {
            Monitors.recordTaskRateLimited((String)task.getTaskDefName(), (int)limit);
            return true;
        }
        this.logger.info("Task execution count for {}: limit={}, current={}", new Object[]{task.getTaskDefName(), limit, this.getInProgressTaskCount(task.getTaskDefName())});
        String taskId = task.getTaskId();
        List<String> tasksInProgressInOrderOfArrival = this.findAllTasksInProgressInOrderOfArrival(task, limit);
        boolean bl = rateLimited = !tasksInProgressInOrderOfArrival.contains(taskId);
        if (rateLimited) {
            this.logger.info("Task execution count limited. {}, limit {}, current {}", new Object[]{task.getTaskDefName(), limit, this.getInProgressTaskCount(task.getTaskDefName())});
            Monitors.recordTaskRateLimited((String)task.getTaskDefName(), (int)limit);
        }
        return rateLimited;
    }

    public void updateTasks(List<Task> tasks) {
        this.withTransaction(connection -> tasks.forEach(task -> this.updateTask((Connection)connection, (Task)task)));
    }

    public void addTaskExecLog(List<TaskExecLog> log) {
        this.indexer.add(log);
    }

    public void removeTask(String taskId) {
        Task task = this.getTask(taskId);
        if (task == null) {
            this.logger.warn("No such Task by id {}", (Object)taskId);
            return;
        }
        String taskKey = task.getReferenceTaskName() + "" + task.getRetryCount();
        this.withTransaction(connection -> {
            this.removeScheduledTask((Connection)connection, task, taskKey);
            this.removeWorkflowToTaskMapping((Connection)connection, task);
            this.removeTaskInProgress((Connection)connection, task);
            this.removeTaskData((Connection)connection, task);
        });
    }

    public Task getTask(String taskId) {
        String GET_TASK = "SELECT json_data FROM task WHERE task_id = :taskId";
        String taskJsonStr = this.getWithTransaction(c -> (String)c.createQuery(GET_TASK).addParameter("taskId", taskId).executeScalar(String.class));
        return taskJsonStr != null ? this.readValue(taskJsonStr, Task.class) : null;
    }

    public List<Task> getTasks(List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.getWithTransaction(c -> this.getTasks((Connection)c, taskIds));
    }

    private List<Task> getTasks(Connection connection, List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return Lists.newArrayList();
        }
        String GET_TASKS_FOR_IDS = "SELECT json_data FROM task WHERE task_id IN (%s) AND json_data IS NOT NULL";
        String query = this.generateQueryWithParametersListPlaceholders(GET_TASKS_FOR_IDS, taskIds.size());
        ResultSetHandler resultSetHandler = resultSet -> this.readValue(resultSet.getString("json_data"), Task.class);
        return connection.createQuery(query).withParams(taskIds.toArray()).executeAndFetch(resultSetHandler);
    }

    public List<Task> getPendingTasksForTaskType(String taskName) {
        Preconditions.checkNotNull((Object)taskName, (Object)"task name cannot be null");
        return this.getWithTransaction(connection -> {
            String GET_IN_PROGRESS_TASKS_FOR_TYPE = "SELECT json_data FROM task_in_progress tip INNER JOIN task t ON t.task_id = tip.task_id WHERE task_def_name = :taskDefName";
            ResultSetHandler resultSetHandler = resultSet -> this.readValue(resultSet.getString("json_data"), Task.class);
            return connection.createQuery(GET_IN_PROGRESS_TASKS_FOR_TYPE).addParameter("taskDefName", taskName).executeAndFetch(resultSetHandler);
        });
    }

    public List<Task> getTasksForWorkflow(String workflowId) {
        return this.getWithTransaction(connection -> {
            String GET_TASKS_FOR_WORKFLOW = "SELECT task_id FROM workflow_to_task WHERE workflow_id = :workflowId";
            List taskIds = connection.createQuery(GET_TASKS_FOR_WORKFLOW).addParameter("workflowId", workflowId).executeScalarList(String.class);
            return this.getTasks((Connection)connection, taskIds);
        });
    }

    public String createWorkflow(Workflow workflow) {
        workflow.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        return this.insertOrUpdateWorkflow(workflow, false);
    }

    public String updateWorkflow(Workflow workflow) {
        workflow.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        return this.insertOrUpdateWorkflow(workflow, true);
    }

    public void removeWorkflow(String workflowId, boolean archiveWorkflow) {
        try {
            Workflow wf = this.getWorkflow(workflowId, true);
            if (archiveWorkflow) {
                this.indexer.update(workflowId, new String[]{RAW_JSON_FIELD, ARCHIVED_FIELD}, new Object[]{this.om.writeValueAsString((Object)wf), true});
            } else {
                this.indexer.remove(workflowId);
            }
            this.withTransaction(connection -> {
                this.removeWorkflowDefToWorkflowMapping((Connection)connection, wf);
                this.removeWorkflow((Connection)connection, workflowId);
                this.removePendingWorkflow((Connection)connection, wf.getWorkflowType(), workflowId);
            });
            for (Task task : wf.getTasks()) {
                this.removeTask(task.getTaskId());
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Unable to remove workflow " + workflowId, (Throwable)e);
        }
    }

    public void removeFromPendingWorkflow(String workflowType, String workflowId) {
        this.withTransaction(connection -> this.removePendingWorkflow((Connection)connection, workflowType, workflowId));
    }

    public Workflow getWorkflow(String workflowId) {
        return this.getWorkflow(workflowId, true);
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Workflow workflow = this.getWithTransaction(tx -> this.readWorkflow((Connection)tx, workflowId));
        if (workflow != null) {
            if (includeTasks) {
                List<Task> tasks = this.getTasksForWorkflow(workflowId);
                tasks.sort(Comparator.comparingLong(Task::getScheduledTime).thenComparingInt(Task::getSeq));
                workflow.setTasks(tasks);
            }
            return workflow;
        }
        workflow = this.readWorkflowFromArchive(workflowId);
        if (!includeTasks) {
            workflow.getTasks().clear();
        }
        return workflow;
    }

    public List<String> getRunningWorkflowIds(String workflowName) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        String GET_PENDING_WORKFLOW_IDS = "SELECT workflow_id FROM workflow_pending WHERE workflow_type = :workflowType";
        return this.getWithTransaction(tx -> tx.createQuery(GET_PENDING_WORKFLOW_IDS).addParameter("workflowType", workflowName).executeScalarList(String.class));
    }

    public List<Workflow> getPendingWorkflowsByType(String workflowName) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        return this.getRunningWorkflowIds(workflowName).stream().map(this::getWorkflow).collect(Collectors.toList());
    }

    public long getPendingWorkflowCount(String workflowName) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        String GET_PENDING_WORKFLOW_COUNT = "SELECT COUNT(*) FROM workflow_pending WHERE workflow_type = :workflowType";
        return this.getWithTransaction(tx -> (Long)tx.createQuery(GET_PENDING_WORKFLOW_COUNT).addParameter("workflowType", workflowName).executeScalar(Long.class));
    }

    public long getInProgressTaskCount(String taskDefName) {
        String GET_IN_PROGRESS_TASK_COUNT = "SELECT COUNT(*) FROM task_in_progress WHERE task_def_name = :taskDefName AND in_progress_status = true";
        return this.getWithTransaction(c -> (Long)c.createQuery(GET_IN_PROGRESS_TASK_COUNT).addParameter("taskDefName", taskDefName).executeScalar(Long.class));
    }

    public List<Workflow> getWorkflowsByType(String workflowName, Long startTime, Long endTime) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        Preconditions.checkNotNull((Object)startTime, (Object)"startTime cannot be null");
        Preconditions.checkNotNull((Object)endTime, (Object)"endTime cannot be null");
        LinkedList<Workflow> workflows = new LinkedList<Workflow>();
        this.withTransaction(tx -> {
            String GET_ALL_WORKFLOWS_FOR_WORKFLOW_DEF = "SELECT workflow_id FROM workflow_def_to_workflow WHERE workflow_def = :workflowType AND date_str BETWEEN :start AND :end";
            List workflowIds = tx.createQuery(GET_ALL_WORKFLOWS_FOR_WORKFLOW_DEF).addParameter("workflowType", workflowName).addParameter("start", MySQLExecutionDAO.dateStr(startTime)).addParameter("end", MySQLExecutionDAO.dateStr(endTime)).executeScalarList(String.class);
            workflowIds.forEach(workflowId -> {
                try {
                    Workflow wf = this.getWorkflow((String)workflowId);
                    if (wf.getCreateTime() >= startTime && wf.getCreateTime() <= endTime) {
                        workflows.add(wf);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Unable to load workflow id {} with name {}", new Object[]{workflowId, workflowName, e});
                }
            });
        });
        return workflows;
    }

    public List<Workflow> getWorkflowsByCorrelationId(String correlationId) {
        Preconditions.checkNotNull((Object)correlationId, (Object)"correlationId cannot be null");
        String GET_WORKFLOWS_BY_CORRELATION_ID = "SELECT workflow_id FROM workflow WHERE correlation_id = :correlationId";
        return this.getWithTransaction(tx -> tx.createQuery(GET_WORKFLOWS_BY_CORRELATION_ID).addParameter("correlationId", correlationId).executeScalarList(String.class)).stream().map(this::getWorkflow).collect(Collectors.toList());
    }

    public boolean addEventExecution(EventExecution eventExecution) {
        try {
            boolean added = this.getWithTransaction(tx -> this.insertEventExecution((Connection)tx, eventExecution));
            if (added) {
                this.indexer.add(eventExecution);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Unable to add event execution " + eventExecution.getId(), (Throwable)e);
        }
    }

    public void updateEventExecution(EventExecution eventExecution) {
        try {
            this.withTransaction(tx -> this.updateEventExecution((Connection)tx, eventExecution));
            this.indexer.add(eventExecution);
        }
        catch (Exception e) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Unable to update event execution " + eventExecution.getId(), (Throwable)e);
        }
    }

    public List<EventExecution> getEventExecutions(String eventHandlerName, String eventName, String messageId, int max) {
        try {
            LinkedList executions = Lists.newLinkedList();
            this.withTransaction(tx -> {
                String executionId;
                EventExecution ee;
                for (int i = 0; i < max && (ee = this.readEventExecution((Connection)tx, eventHandlerName, eventName, messageId, executionId = messageId + "_" + i)) != null; ++i) {
                    executions.add(ee);
                }
            });
            return executions;
        }
        catch (Exception e) {
            String message = String.format("Unable to get event executions for eventHandlerName=%s, eventName=%s, messageId=%s", eventHandlerName, eventName, messageId);
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, message, (Throwable)e);
        }
    }

    public void addMessage(String queue, Message msg) {
        this.indexer.addMessage(queue, msg);
    }

    public void updateLastPoll(String taskDefName, String domain, String workerId) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        PollData pollData = new PollData(taskDefName, domain, workerId, System.currentTimeMillis());
        String effectiveDomain = domain == null ? "DEFAULT" : domain;
        this.withTransaction(tx -> this.insertOrUpdatePollData((Connection)tx, pollData, effectiveDomain));
    }

    public PollData getPollData(String taskDefName, String domain) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        String effectiveDomain = domain == null ? "DEFAULT" : domain;
        return this.getWithTransaction(tx -> this.readPollData((Connection)tx, taskDefName, effectiveDomain));
    }

    public List<PollData> getPollData(String taskDefName) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        return this.readAllPollData(taskDefName);
    }

    private String insertOrUpdateWorkflow(Workflow workflow, boolean update) {
        Preconditions.checkNotNull((Object)workflow, (Object)"workflow object cannot be null");
        boolean terminal = workflow.getStatus().isTerminal();
        if (terminal) {
            workflow.setEndTime(System.currentTimeMillis());
        }
        List tasks = workflow.getTasks();
        workflow.setTasks((List)Lists.newLinkedList());
        this.withTransaction(tx -> {
            if (!update) {
                this.addWorkflow((Connection)tx, workflow);
                this.addWorkflowDefToWorkflowMapping((Connection)tx, workflow);
            } else {
                this.updateWorkflow((Connection)tx, workflow);
            }
            if (terminal) {
                this.removePendingWorkflow((Connection)tx, workflow.getWorkflowType(), workflow.getWorkflowId());
            } else {
                this.addPendingWorkflow((Connection)tx, workflow.getWorkflowType(), workflow.getWorkflowId());
            }
        });
        workflow.setTasks(tasks);
        this.indexer.index(workflow);
        return workflow.getWorkflowId();
    }

    private void updateTask(Connection connection, Task task) {
        TaskDef taskDef;
        task.setUpdateTime(System.currentTimeMillis());
        if (task.getStatus() != null && task.getStatus().isTerminal()) {
            task.setEndTime(System.currentTimeMillis());
        }
        if ((taskDef = this.metadata.getTaskDef(task.getTaskDefName())) != null && taskDef.concurrencyLimit() > 0) {
            boolean inProgress = task.getStatus() != null && task.getStatus().equals((Object)Task.Status.IN_PROGRESS);
            this.updateInProgressStatus(connection, task, inProgress);
        }
        this.insertOrUpdateTaskData(connection, task);
        if (task.getStatus() != null && task.getStatus().isTerminal()) {
            this.removeTaskInProgress(connection, task);
        }
        this.indexer.index(task);
    }

    private Workflow readWorkflow(Connection connection, String workflowId) {
        String GET_WORKFLOW = "SELECT json_data FROM workflow WHERE workflow_id = :workflowId";
        String json = (String)connection.createQuery(GET_WORKFLOW).addParameter("workflowId", workflowId).executeScalar(String.class);
        return json != null ? this.readValue(json, Workflow.class) : null;
    }

    private Workflow readWorkflowFromArchive(String workflowId) {
        String json = this.indexer.get(workflowId, RAW_JSON_FIELD);
        if (json != null) {
            return this.readValue(json, Workflow.class);
        }
        throw new ApplicationException(ApplicationException.Code.NOT_FOUND, "No such workflow found by id: " + workflowId);
    }

    private void addWorkflow(Connection connection, Workflow workflow) {
        String INSERT_WORKFLOW = "INSERT INTO workflow (workflow_id, correlation_id, json_data) VALUES (:workflowId, :correlationId, :jsonData)";
        connection.createQuery(INSERT_WORKFLOW).addParameter("workflowId", workflow.getWorkflowId()).addParameter("correlationId", workflow.getCorrelationId()).addParameter("jsonData", this.toJson(workflow)).executeUpdate();
    }

    private void updateWorkflow(Connection connection, Workflow workflow) {
        String UPDATE_WORKFLOW = "UPDATE workflow SET json_data = :jsonData, modified_on = CURRENT_TIMESTAMP WHERE workflow_id = :workflowId";
        connection.createQuery(UPDATE_WORKFLOW).addParameter("workflowId", workflow.getWorkflowId()).addParameter("jsonData", this.toJson(workflow)).executeUpdate();
    }

    private void removeWorkflow(Connection connection, String workflowId) {
        String REMOVE_WORKFLOW = "DELETE FROM workflow WHERE workflow_id = :workflowId";
        connection.createQuery(REMOVE_WORKFLOW).addParameter("workflowId", workflowId).executeUpdate();
    }

    private void addPendingWorkflow(Connection connection, String workflowType, String workflowId) {
        String EXISTS_PENDING_WORKFLOW = "SELECT EXISTS(SELECT 1 FROM workflow_pending WHERE workflow_type = :workflowType AND workflow_id = :workflowId)";
        boolean exist = (Boolean)connection.createQuery(EXISTS_PENDING_WORKFLOW).addParameter("workflowType", workflowType).addParameter("workflowId", workflowId).executeScalar(Boolean.class);
        if (!exist) {
            String INSERT_PENDING_WORKFLOW = "INSERT INTO workflow_pending (workflow_type, workflow_id) VALUES (:workflowType, :workflowId)";
            connection.createQuery(INSERT_PENDING_WORKFLOW).addParameter("workflowType", workflowType).addParameter("workflowId", workflowId).executeUpdate();
        }
    }

    private void removePendingWorkflow(Connection connection, String workflowType, String workflowId) {
        String REMOVE_PENDING_WORKFLOW = "DELETE FROM workflow_pending WHERE workflow_type = :workflowType AND workflow_id = :workflowId";
        connection.createQuery(REMOVE_PENDING_WORKFLOW).addParameter("workflowType", workflowType).addParameter("workflowId", workflowId).executeUpdate();
    }

    private void insertOrUpdateTaskData(Connection connection, Task task) {
        String UPDATE_TASK = "UPDATE task SET json_data = :jsonData, modified_on = CURRENT_TIMESTAMP WHERE task_id = :taskId";
        int result = connection.createQuery(UPDATE_TASK).addParameter("taskId", task.getTaskId()).addParameter("jsonData", this.toJson(task)).executeUpdate().getResult();
        if (result == 0) {
            String INSERT_TASK = "INSERT INTO task (task_id, json_data) VALUES (:taskId, :jsonData)";
            connection.createQuery(INSERT_TASK).addParameter("taskId", task.getTaskId()).addParameter("jsonData", this.toJson(task)).executeUpdate().getResult();
        }
    }

    private void removeTaskData(Connection connection, Task task) {
        String REMOVE_TASK = "DELETE FROM task WHERE task_id = :taskId";
        connection.createQuery(REMOVE_TASK).addParameter("taskId", task.getTaskId()).executeUpdate();
    }

    private void addWorkflowToTaskMapping(Connection connection, Task task) {
        String EXISTS_WORKFLOW_TO_TASK = "SELECT EXISTS(SELECT 1 FROM workflow_to_task WHERE workflow_id = :workflowId AND task_id = :taskId)";
        boolean exist = (Boolean)connection.createQuery(EXISTS_WORKFLOW_TO_TASK).addParameter("workflowId", task.getWorkflowInstanceId()).addParameter("taskId", task.getTaskId()).executeScalar(Boolean.class);
        if (!exist) {
            String INSERT_WORKFLOW_TO_TASK = "INSERT INTO workflow_to_task (workflow_id, task_id) VALUES (:workflowId, :taskId)";
            connection.createQuery(INSERT_WORKFLOW_TO_TASK).addParameter("workflowId", task.getWorkflowInstanceId()).addParameter("taskId", task.getTaskId()).executeUpdate();
        }
    }

    private void removeWorkflowToTaskMapping(Connection connection, Task task) {
        String REMOVE_WORKFLOW_TO_TASK = "DELETE FROM workflow_to_task WHERE workflow_id = :workflowId AND task_id = :taskId";
        connection.createQuery(REMOVE_WORKFLOW_TO_TASK).addParameter("workflowId", task.getWorkflowInstanceId()).addParameter("taskId", task.getTaskId()).executeUpdate();
    }

    private void addWorkflowDefToWorkflowMapping(Connection connection, Workflow workflow) {
        String INSERT_WORKFLOW_DEF_TO_WORKFLOW = "INSERT INTO workflow_def_to_workflow (workflow_def, date_str, workflow_id) VALUES (:workflowType, :dateStr, :workflowId)";
        connection.createQuery(INSERT_WORKFLOW_DEF_TO_WORKFLOW).bind((Object)workflow).addParameter("dateStr", MySQLExecutionDAO.dateStr(workflow.getCreateTime())).executeUpdate();
    }

    private void removeWorkflowDefToWorkflowMapping(Connection connection, Workflow workflow) {
        String REMOVE_WORKFLOW_DEF_TO_WORKFLOW = "DELETE FROM workflow_def_to_workflow WHERE workflow_def = :workflowType AND date_str = :dateStr AND workflow_id = :workflowId";
        connection.createQuery(REMOVE_WORKFLOW_DEF_TO_WORKFLOW).bind((Object)workflow).addParameter("dateStr", MySQLExecutionDAO.dateStr(workflow.getCreateTime())).executeUpdate();
    }

    private boolean addScheduledTask(Connection connection, Task task, String taskKey) {
        String EXISTS_SCHEDULED_TASK = "SELECT EXISTS(SELECT 1 FROM task_scheduled WHERE workflow_id = :workflowId AND task_key = :taskKey)";
        boolean exist = (Boolean)connection.createQuery(EXISTS_SCHEDULED_TASK).addParameter("workflowId", task.getWorkflowInstanceId()).addParameter("taskKey", taskKey).executeScalar(Boolean.class);
        if (!exist) {
            String INSERT_SCHEDULED_TASK = "INSERT INTO task_scheduled (workflow_id, task_key, task_id) VALUES (:workflowId, :taskKey, :taskId)";
            connection.createQuery(INSERT_SCHEDULED_TASK).addParameter("workflowId", task.getWorkflowInstanceId()).addParameter("taskKey", taskKey).addParameter("taskId", task.getTaskId()).executeUpdate().getResult();
            return true;
        }
        return false;
    }

    private void removeScheduledTask(Connection connection, Task task, String taskKey) {
        String REMOVE_SCHEDULED_TASK = "DELETE FROM task_scheduled WHERE workflow_id = :workflowId AND task_key = :taskKey";
        connection.createQuery(REMOVE_SCHEDULED_TASK).addParameter("workflowId", task.getWorkflowInstanceId()).addParameter("taskKey", taskKey).executeUpdate().getResult();
    }

    private void addTaskInProgress(Connection connection, Task task) {
        String EXISTS_IN_PROGRESS_TASK = "SELECT EXISTS(SELECT 1 FROM task_in_progress WHERE task_def_name = :taskDefName AND task_id = :taskId)";
        boolean exist = (Boolean)connection.createQuery(EXISTS_IN_PROGRESS_TASK).addParameter("taskDefName", task.getTaskDefName()).addParameter("taskId", task.getTaskId()).executeScalar(Boolean.class);
        if (!exist) {
            String INSERT_IN_PROGRESS_TASK = "INSERT INTO task_in_progress (task_def_name, task_id, workflow_id) VALUES (:taskDefName, :taskId, :workflowId)";
            connection.createQuery(INSERT_IN_PROGRESS_TASK).addParameter("taskDefName", task.getTaskDefName()).addParameter("taskId", task.getTaskId()).addParameter("workflowId", task.getWorkflowInstanceId()).executeUpdate();
        }
    }

    private void removeTaskInProgress(Connection connection, Task task) {
        String REMOVE_IN_PROGRESS_TASK = "DELETE FROM task_in_progress WHERE task_def_name = :taskDefName AND task_id = :taskId";
        connection.createQuery(REMOVE_IN_PROGRESS_TASK).addParameter("taskDefName", task.getTaskDefName()).addParameter("taskId", task.getTaskId()).executeUpdate();
    }

    private void updateInProgressStatus(Connection connection, Task task, boolean inProgress) {
        String UPDATE_IN_PROGRESS_TASK_STATUS = "UPDATE task_in_progress SET in_progress_status = :inProgress, modified_on = CURRENT_TIMESTAMP WHERE task_def_name = :taskDefName AND task_id = :taskId";
        connection.createQuery(UPDATE_IN_PROGRESS_TASK_STATUS).addParameter("taskDefName", task.getTaskDefName()).addParameter("taskId", task.getTaskId()).addParameter("inProgress", (Object)inProgress).executeUpdate();
    }

    private boolean insertEventExecution(Connection connection, EventExecution eventExecution) {
        String EXISTS_EVENT_EXECUTION = "SELECT EXISTS(SELECT 1 FROM event_execution WHERE event_handler_name = :name AND event_name = :event AND message_id = :messageId AND execution_id = :id)";
        boolean exist = (Boolean)connection.createQuery(EXISTS_EVENT_EXECUTION).bind((Object)eventExecution).executeScalar(Boolean.class);
        if (!exist) {
            String INSERT_EVENT_EXECUTION = "INSERT INTO event_execution (event_handler_name, event_name, message_id, execution_id, json_data) VALUES (:name, :event, :messageId, :id, :jsonData)";
            connection.createQuery(INSERT_EVENT_EXECUTION).bind((Object)eventExecution).addParameter("jsonData", this.toJson(eventExecution)).executeUpdate();
            return true;
        }
        return false;
    }

    private void updateEventExecution(Connection connection, EventExecution eventExecution) {
        String UPDATE_EVENT_EXECUTION = "UPDATE event_execution SET json_data = :jsonData, modified_on = CURRENT_TIMESTAMP WHERE event_handler_name = :name AND execution_event = :event AND message_id = :messageId AND execution_id = :id";
        connection.createQuery(UPDATE_EVENT_EXECUTION).bind((Object)eventExecution).addParameter("jsonData", this.toJson(eventExecution)).executeUpdate();
    }

    private EventExecution readEventExecution(Connection connection, String eventHandlerName, String eventName, String messageId, String executionId) {
        String GET_EVENT_EXECUTION = "SELECT json_data FROM event_execution WHERE event_handler_name = :name AND event_name = :event AND message_id = :messageId AND execution_id = :id";
        String jsonStr = (String)connection.createQuery(GET_EVENT_EXECUTION).addParameter("name", eventHandlerName).addParameter("event", eventName).addParameter("messageId", messageId).addParameter("id", executionId).executeScalar(String.class);
        return jsonStr != null ? this.readValue(jsonStr, EventExecution.class) : null;
    }

    private void insertOrUpdatePollData(Connection connection, PollData pollData, String domain) {
        String UPDATE_POLL_DATA = "UPDATE poll_data SET json_data = :jsonData, modified_on = CURRENT_TIMESTAMP WHERE queue_name = :queueName AND domain = :domain";
        int result = connection.createQuery(UPDATE_POLL_DATA).addParameter("queueName", pollData.getQueueName()).addParameter("domain", domain).addParameter("jsonData", this.toJson(pollData)).executeUpdate().getResult();
        if (result == 0) {
            String INSERT_POLL_DATA = "INSERT INTO poll_data (queue_name, domain, json_data) VALUES (:queueName, :domain, :jsonData)";
            connection.createQuery(INSERT_POLL_DATA).addParameter("queueName", pollData.getQueueName()).addParameter("domain", domain).addParameter("jsonData", this.toJson(pollData)).executeUpdate().getResult();
        }
    }

    private PollData readPollData(Connection connection, String queueName, String domain) {
        String GET_POLL_DATA = "SELECT json_data FROM poll_data WHERE queue_name = :queueName AND domain = :domain";
        String jsonStr = (String)connection.createQuery(GET_POLL_DATA).addParameter("queueName", queueName).addParameter("domain", domain).executeScalar(String.class);
        return jsonStr != null ? this.readValue(jsonStr, PollData.class) : null;
    }

    private List<PollData> readAllPollData(String queueName) {
        String GET_ALL_POLL_DATA = "SELECT json_data FROM poll_data WHERE queue_name = :queueName";
        return this.getWithTransaction(tx -> tx.createQuery(GET_ALL_POLL_DATA).addParameter("queueName", queueName).executeScalarList(String.class).stream().map(jsonData -> this.readValue((String)jsonData, PollData.class)).collect(Collectors.toList()));
    }

    private List<String> findAllTasksInProgressInOrderOfArrival(Task task, int limit) {
        String GET_IN_PROGRESS_TASKS_WITH_LIMIT = "SELECT task_id FROM task_in_progress WHERE task_def_name = :taskDefName ORDER BY id LIMIT :limit";
        return this.getWithTransaction(connection -> connection.createQuery(GET_IN_PROGRESS_TASKS_WITH_LIMIT).addParameter("taskDefName", task.getTaskDefName()).addParameter("limit", limit).executeScalarList(String.class));
    }

    private void validate(Task task) {
        Preconditions.checkNotNull((Object)task, (Object)"task object cannot be null");
        Preconditions.checkNotNull((Object)task.getTaskId(), (Object)"Task id cannot be null");
        Preconditions.checkNotNull((Object)task.getWorkflowInstanceId(), (Object)"Workflow instance id cannot be null");
        Preconditions.checkNotNull((Object)task.getReferenceTaskName(), (Object)"Task reference name cannot be null");
    }

    private static String dateStr(Long timeInMs) {
        Date date = new Date(timeInMs);
        return MySQLExecutionDAO.dateStr(date);
    }

    private static String dateStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }
}

