/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.mysql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

abstract class MySQLBaseDAO {
    private static final List<String> EXCLUDED_STACKTRACE_CLASS = ImmutableList.of((Object)"com.netflix.conductor.dao.mysql.MySQLBaseDAO", (Object)"java.lang.Thread");
    protected final Sql2o sql2o;
    protected final ObjectMapper om;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected MySQLBaseDAO(ObjectMapper om, Sql2o sql2o) {
        this.om = om;
        this.sql2o = sql2o;
    }

    protected String toJson(Object value) {
        try {
            return this.om.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.om.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    protected <R> R getWithTransaction(Function<Connection, R> function) {
        Instant start = Instant.now();
        StackTraceElement caller = Arrays.stream(Thread.currentThread().getStackTrace()).filter(ste -> !EXCLUDED_STACKTRACE_CLASS.contains(ste.getClassName())).findFirst().get();
        this.logger.debug("{} : starting transaction", (Object)caller.getMethodName());
        try {
            R r;
            try (Connection connection = this.sql2o.beginTransaction(2);){
                R result = function.apply(connection);
                connection.commit();
                r = result;
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Instant end = Instant.now();
            this.logger.debug("{} : took {}ms", (Object)caller.getMethodName(), (Object)Duration.between(start, end).toMillis());
        }
    }

    protected void withTransaction(Consumer<Connection> consumer) {
        this.getWithTransaction(connection -> {
            consumer.accept((Connection)connection);
            return null;
        });
    }

    protected String generateQueryWithParametersListPlaceholders(String queryTemplate, int numPlaceholders) {
        String paramsPlaceholders = String.join((CharSequence)",", IntStream.rangeClosed(1, numPlaceholders).mapToObj(paramNumber -> ":p" + paramNumber).collect(Collectors.toList()));
        return String.format(queryTemplate, paramsPlaceholders);
    }
}

