/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.mysql;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.netflix.conductor.core.config.Configuration;
import com.netflix.conductor.dao.ExecutionDAO;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.dao.QueueDAO;
import com.netflix.conductor.dao.mysql.MySQLExecutionDAO;
import com.netflix.conductor.dao.mysql.MySQLMetadataDAO;
import com.netflix.conductor.dao.mysql.MySQLQueueDAO;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLWorkflowModule
extends AbstractModule {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Provides
    @Singleton
    public DataSource getDataSource(Configuration config) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(config.getProperty("jdbc.url", "jdbc:mysql://localhost:3306/conductor"));
        dataSource.setUsername(config.getProperty("jdbc.username", "conductor"));
        dataSource.setPassword(config.getProperty("jdbc.password", "password"));
        dataSource.setAutoCommit(false);
        this.flywayMigrate(config, (DataSource)dataSource);
        return dataSource;
    }

    protected void configure() {
        this.bind(MetadataDAO.class).to(MySQLMetadataDAO.class);
        this.bind(ExecutionDAO.class).to(MySQLExecutionDAO.class);
        this.bind(QueueDAO.class).to(MySQLQueueDAO.class);
    }

    private void flywayMigrate(Configuration config, DataSource dataSource) {
        boolean enabled = this.getBool(config.getProperty("flyway.enabled", "true"), true);
        if (!enabled) {
            this.logger.debug("Flyway migrations are disabled");
            return;
        }
        String migrationTable = config.getProperty("flyway.table", null);
        Flyway flyway = new Flyway();
        if (null != migrationTable) {
            this.logger.debug("Using Flyway migration table '{}'", (Object)migrationTable);
            flyway.setTable(migrationTable);
        }
        flyway.setDataSource(dataSource);
        flyway.setPlaceholderReplacement(false);
        flyway.migrate();
    }

    private boolean getBool(String value, boolean defaultValue) {
        if (null == value || value.trim().length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(value.trim());
    }
}

