/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.dao.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.conductor.common.metadata.events.EventExecution;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.core.events.queue.Message;
import com.netflix.conductor.core.execution.ApplicationException;
import com.netflix.conductor.dao.ExecutionDAO;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.dao.mysql.MySQLBaseDAO;
import com.netflix.conductor.dao.mysql.Query;
import com.netflix.conductor.metrics.Monitors;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.sql.DataSource;

public class MySQLExecutionDAO
extends MySQLBaseDAO
implements ExecutionDAO {
    private static final String ARCHIVED_FIELD = "archived";
    private static final String RAW_JSON_FIELD = "rawJSON";
    private IndexDAO indexer;

    @Inject
    public MySQLExecutionDAO(IndexDAO indexer, ObjectMapper om, DataSource dataSource) {
        super(om, dataSource);
        this.indexer = indexer;
    }

    private static String dateStr(Long timeInMs) {
        Date date = new Date(timeInMs);
        return MySQLExecutionDAO.dateStr(date);
    }

    private static String dateStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }

    public List<Task> getPendingTasksByWorkflow(String taskDefName, String workflowId) {
        String GET_IN_PROGRESS_TASKS_FOR_WORKFLOW = "SELECT json_data FROM task_in_progress tip INNER JOIN task t ON t.task_id = tip.task_id WHERE task_def_name = ? AND workflow_id = ?";
        return this.queryWithTransaction(GET_IN_PROGRESS_TASKS_FOR_WORKFLOW, q -> q.addParameter(taskDefName).addParameter(workflowId).executeAndFetch(Task.class));
    }

    public List<Task> getTasks(String taskDefName, String startKey, int count) {
        ArrayList<Task> tasks = new ArrayList<Task>(count);
        List<Task> pendingTasks = this.getPendingTasksForTaskType(taskDefName);
        boolean startKeyFound = startKey == null;
        int found = 0;
        for (Task pendingTask : pendingTasks) {
            if (!startKeyFound && pendingTask.getTaskId().equals(startKey)) {
                startKeyFound = true;
                if (startKey != null) continue;
            }
            if (!startKeyFound || found >= count) continue;
            tasks.add(pendingTask);
            ++found;
        }
        return tasks;
    }

    public List<Task> createTasks(List<Task> tasks) {
        ArrayList created = Lists.newArrayListWithCapacity((int)tasks.size());
        this.withTransaction(connection -> {
            for (Task task : tasks) {
                this.validate(task);
                task.setScheduledTime(System.currentTimeMillis());
                String taskKey = task.getReferenceTaskName() + "" + task.getRetryCount();
                boolean scheduledTaskAdded = this.addScheduledTask((Connection)connection, task, taskKey);
                if (!scheduledTaskAdded) {
                    this.logger.info("Task already scheduled, skipping the run " + task.getTaskId() + ", ref=" + task.getReferenceTaskName() + ", key=" + taskKey);
                    continue;
                }
                this.insertOrUpdateTaskData((Connection)connection, task);
                this.addWorkflowToTaskMapping((Connection)connection, task);
                this.addTaskInProgress((Connection)connection, task);
                this.updateTask((Connection)connection, task);
                created.add(task);
            }
        });
        return created;
    }

    public void updateTask(Task task) {
        this.withTransaction(connection -> this.updateTask((Connection)connection, task));
    }

    public boolean exceedsRateLimitPerFrequency(Task task) {
        return false;
    }

    public boolean exceedsInProgressLimit(Task task) {
        boolean rateLimited;
        Optional taskDefinition = task.getTaskDefinition();
        if (!taskDefinition.isPresent()) {
            return false;
        }
        TaskDef taskDef = (TaskDef)taskDefinition.get();
        int limit = taskDef.concurrencyLimit();
        if (limit <= 0) {
            return false;
        }
        long current = this.getInProgressTaskCount(task.getTaskDefName());
        if (current >= (long)limit) {
            Monitors.recordTaskConcurrentExecutionLimited((String)task.getTaskDefName(), (int)limit);
            return true;
        }
        this.logger.info("Task execution count for {}: limit={}, current={}", new Object[]{task.getTaskDefName(), limit, this.getInProgressTaskCount(task.getTaskDefName())});
        String taskId = task.getTaskId();
        List<String> tasksInProgressInOrderOfArrival = this.findAllTasksInProgressInOrderOfArrival(task, limit);
        boolean bl = rateLimited = !tasksInProgressInOrderOfArrival.contains(taskId);
        if (rateLimited) {
            this.logger.info("Task execution count limited. {}, limit {}, current {}", new Object[]{task.getTaskDefName(), limit, this.getInProgressTaskCount(task.getTaskDefName())});
            Monitors.recordTaskConcurrentExecutionLimited((String)task.getTaskDefName(), (int)limit);
        }
        return rateLimited;
    }

    public void updateTasks(List<Task> tasks) {
        this.withTransaction(connection -> tasks.forEach(task -> this.updateTask((Connection)connection, (Task)task)));
    }

    public void addTaskExecLog(List<TaskExecLog> log) {
        this.indexer.addTaskExecutionLogs(log);
    }

    public void removeTask(String taskId) {
        Task task = this.getTask(taskId);
        if (task == null) {
            this.logger.warn("No such Task by id {}", (Object)taskId);
            return;
        }
        String taskKey = task.getReferenceTaskName() + "_" + task.getRetryCount();
        this.withTransaction(connection -> {
            this.removeScheduledTask((Connection)connection, task, taskKey);
            this.removeWorkflowToTaskMapping((Connection)connection, task);
            this.removeTaskInProgress((Connection)connection, task);
            this.removeTaskData((Connection)connection, task);
        });
    }

    public Task getTask(String taskId) {
        String GET_TASK = "SELECT json_data FROM task WHERE task_id = ?";
        return this.queryWithTransaction(GET_TASK, q -> q.addParameter(taskId).executeAndFetchFirst(Task.class));
    }

    public List<Task> getTasks(List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.getWithTransaction(c -> this.getTasks(c, taskIds));
    }

    public List<Task> getPendingTasksForTaskType(String taskName) {
        Preconditions.checkNotNull((Object)taskName, (Object)"task name cannot be null");
        String GET_IN_PROGRESS_TASKS_FOR_TYPE = "SELECT json_data FROM task_in_progress tip INNER JOIN task t ON t.task_id = tip.task_id WHERE task_def_name = ?";
        return this.queryWithTransaction(GET_IN_PROGRESS_TASKS_FOR_TYPE, q -> q.addParameter(taskName).executeAndFetch(Task.class));
    }

    public List<Task> getTasksForWorkflow(String workflowId) {
        String GET_TASKS_FOR_WORKFLOW = "SELECT task_id FROM workflow_to_task WHERE workflow_id = ?";
        return this.getWithTransaction(tx -> this.query(tx, GET_TASKS_FOR_WORKFLOW, q -> {
            List<String> taskIds = q.addParameter(workflowId).executeScalarList(String.class);
            return this.getTasks(tx, taskIds);
        }));
    }

    public String createWorkflow(Workflow workflow) {
        workflow.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        return this.insertOrUpdateWorkflow(workflow, false);
    }

    public String updateWorkflow(Workflow workflow) {
        workflow.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        return this.insertOrUpdateWorkflow(workflow, true);
    }

    public void removeWorkflow(String workflowId, boolean archiveWorkflow) {
        try {
            Workflow wf = this.getWorkflow(workflowId, true);
            if (archiveWorkflow) {
                this.indexer.updateWorkflow(workflowId, new String[]{RAW_JSON_FIELD, ARCHIVED_FIELD}, new Object[]{this.objectMapper.writeValueAsString((Object)wf), true});
            } else {
                this.indexer.removeWorkflow(workflowId);
            }
            this.withTransaction(connection -> {
                this.removeWorkflowDefToWorkflowMapping((Connection)connection, wf);
                this.removeWorkflow((Connection)connection, workflowId);
                this.removePendingWorkflow((Connection)connection, wf.getWorkflowName(), workflowId);
            });
            for (Task task : wf.getTasks()) {
                this.removeTask(task.getTaskId());
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Unable to remove workflow " + workflowId, (Throwable)e);
        }
    }

    public void removeFromPendingWorkflow(String workflowType, String workflowId) {
        this.withTransaction(connection -> this.removePendingWorkflow((Connection)connection, workflowType, workflowId));
    }

    public Workflow getWorkflow(String workflowId) {
        return this.getWorkflow(workflowId, true);
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Workflow workflow = this.getWithTransaction(tx -> this.readWorkflow(tx, workflowId));
        if (workflow != null) {
            if (includeTasks) {
                List<Task> tasks = this.getTasksForWorkflow(workflowId);
                tasks.sort(Comparator.comparingLong(Task::getScheduledTime).thenComparingInt(Task::getSeq));
                workflow.setTasks(tasks);
            }
        } else {
            workflow = this.readWorkflowFromArchive(workflowId);
        }
        if (!includeTasks) {
            workflow.getTasks().clear();
        }
        return workflow;
    }

    public List<String> getRunningWorkflowIds(String workflowName) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        String GET_PENDING_WORKFLOW_IDS = "SELECT workflow_id FROM workflow_pending WHERE workflow_type = ?";
        return this.queryWithTransaction(GET_PENDING_WORKFLOW_IDS, q -> q.addParameter(workflowName).executeScalarList(String.class));
    }

    public List<Workflow> getPendingWorkflowsByType(String workflowName) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        return this.getRunningWorkflowIds(workflowName).stream().map(this::getWorkflow).collect(Collectors.toList());
    }

    public long getPendingWorkflowCount(String workflowName) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        String GET_PENDING_WORKFLOW_COUNT = "SELECT COUNT(*) FROM workflow_pending WHERE workflow_type = ?";
        return this.queryWithTransaction(GET_PENDING_WORKFLOW_COUNT, q -> q.addParameter(workflowName).executeCount());
    }

    public long getInProgressTaskCount(String taskDefName) {
        String GET_IN_PROGRESS_TASK_COUNT = "SELECT COUNT(*) FROM task_in_progress WHERE task_def_name = ? AND in_progress_status = true";
        return this.queryWithTransaction(GET_IN_PROGRESS_TASK_COUNT, q -> q.addParameter(taskDefName).executeCount());
    }

    public List<Workflow> getWorkflowsByType(String workflowName, Long startTime, Long endTime) {
        Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName cannot be null");
        Preconditions.checkNotNull((Object)startTime, (Object)"startTime cannot be null");
        Preconditions.checkNotNull((Object)endTime, (Object)"endTime cannot be null");
        LinkedList<Workflow> workflows = new LinkedList<Workflow>();
        this.withTransaction(tx -> {
            String GET_ALL_WORKFLOWS_FOR_WORKFLOW_DEF = "SELECT workflow_id FROM workflow_def_to_workflow WHERE workflow_def = ? AND date_str BETWEEN ? AND ?";
            List workflowIds = this.query((Connection)tx, GET_ALL_WORKFLOWS_FOR_WORKFLOW_DEF, q -> q.addParameter(workflowName).addParameter(MySQLExecutionDAO.dateStr(startTime)).addParameter(MySQLExecutionDAO.dateStr(endTime)).executeScalarList(String.class));
            workflowIds.forEach(workflowId -> {
                try {
                    Workflow wf = this.getWorkflow((String)workflowId);
                    if (wf.getCreateTime() >= startTime && wf.getCreateTime() <= endTime) {
                        workflows.add(wf);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Unable to load workflow id {} with name {}", new Object[]{workflowId, workflowName, e});
                }
            });
        });
        return workflows;
    }

    public List<Workflow> getWorkflowsByCorrelationId(String correlationId, boolean includeTasks) {
        Preconditions.checkNotNull((Object)correlationId, (Object)"correlationId cannot be null");
        String GET_WORKFLOWS_BY_CORRELATION_ID = "SELECT workflow_id FROM workflow WHERE correlation_id = ?";
        return this.queryWithTransaction(GET_WORKFLOWS_BY_CORRELATION_ID, q -> q.addParameter(correlationId).executeScalarList(String.class).stream().map(workflowId -> this.getWorkflow((String)workflowId, includeTasks)).collect(Collectors.toList()));
    }

    public boolean addEventExecution(EventExecution eventExecution) {
        try {
            boolean added = this.getWithTransaction(tx -> this.insertEventExecution(tx, eventExecution));
            if (added) {
                this.indexer.addEventExecution(eventExecution);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Unable to add event execution " + eventExecution.getId(), (Throwable)e);
        }
    }

    public void removeEventExecution(EventExecution eventExecution) {
        try {
            this.withTransaction(tx -> this.removeEventExecution((Connection)tx, eventExecution));
        }
        catch (Exception e) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Unable to remove event execution " + eventExecution.getId(), (Throwable)e);
        }
    }

    public void updateEventExecution(EventExecution eventExecution) {
        try {
            this.withTransaction(tx -> this.updateEventExecution((Connection)tx, eventExecution));
            this.indexer.addEventExecution(eventExecution);
        }
        catch (Exception e) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, "Unable to update event execution " + eventExecution.getId(), (Throwable)e);
        }
    }

    public List<EventExecution> getEventExecutions(String eventHandlerName, String eventName, String messageId, int max) {
        try {
            LinkedList executions = Lists.newLinkedList();
            this.withTransaction(tx -> {
                String executionId;
                EventExecution ee;
                for (int i = 0; i < max && (ee = this.readEventExecution((Connection)tx, eventHandlerName, eventName, messageId, executionId = messageId + "_" + i)) != null; ++i) {
                    executions.add(ee);
                }
            });
            return executions;
        }
        catch (Exception e) {
            String message = String.format("Unable to get event executions for eventHandlerName=%s, eventName=%s, messageId=%s", eventHandlerName, eventName, messageId);
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, message, (Throwable)e);
        }
    }

    public void addMessage(String queue, Message msg) {
        this.indexer.addMessage(queue, msg);
    }

    public void updateLastPoll(String taskDefName, String domain, String workerId) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        PollData pollData = new PollData(taskDefName, domain, workerId, System.currentTimeMillis());
        String effectiveDomain = domain == null ? "DEFAULT" : domain;
        this.withTransaction(tx -> this.insertOrUpdatePollData((Connection)tx, pollData, effectiveDomain));
    }

    public PollData getPollData(String taskDefName, String domain) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        String effectiveDomain = domain == null ? "DEFAULT" : domain;
        return this.getWithTransaction(tx -> this.readPollData(tx, taskDefName, effectiveDomain));
    }

    public List<PollData> getPollData(String taskDefName) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        return this.readAllPollData(taskDefName);
    }

    private List<Task> getTasks(Connection connection, List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return Lists.newArrayList();
        }
        String GET_TASKS_FOR_IDS = String.format("SELECT json_data FROM task WHERE task_id IN (%s) AND json_data IS NOT NULL", Query.generateInBindings(taskIds.size()));
        return this.query(connection, GET_TASKS_FOR_IDS, q -> q.addParameters(taskIds).executeAndFetch(Task.class));
    }

    private String insertOrUpdateWorkflow(Workflow workflow, boolean update) {
        Preconditions.checkNotNull((Object)workflow, (Object)"workflow object cannot be null");
        boolean terminal = workflow.getStatus().isTerminal();
        if (terminal) {
            workflow.setEndTime(System.currentTimeMillis());
        }
        List tasks = workflow.getTasks();
        workflow.setTasks((List)Lists.newLinkedList());
        this.withTransaction(tx -> {
            if (!update) {
                this.addWorkflow((Connection)tx, workflow);
                this.addWorkflowDefToWorkflowMapping((Connection)tx, workflow);
            } else {
                this.updateWorkflow((Connection)tx, workflow);
            }
            if (terminal) {
                this.removePendingWorkflow((Connection)tx, workflow.getWorkflowName(), workflow.getWorkflowId());
            } else {
                this.addPendingWorkflow((Connection)tx, workflow.getWorkflowName(), workflow.getWorkflowId());
            }
        });
        workflow.setTasks(tasks);
        this.indexer.indexWorkflow(workflow);
        return workflow.getWorkflowId();
    }

    private void updateTask(Connection connection, Task task) {
        Optional taskDefinition;
        task.setUpdateTime(System.currentTimeMillis());
        if (task.getStatus() != null && task.getStatus().isTerminal()) {
            task.setEndTime(System.currentTimeMillis());
        }
        if ((taskDefinition = task.getTaskDefinition()).isPresent() && ((TaskDef)taskDefinition.get()).concurrencyLimit() > 0) {
            boolean inProgress = task.getStatus() != null && task.getStatus().equals((Object)Task.Status.IN_PROGRESS);
            this.updateInProgressStatus(connection, task, inProgress);
        }
        this.insertOrUpdateTaskData(connection, task);
        if (task.getStatus() != null && task.getStatus().isTerminal()) {
            this.removeTaskInProgress(connection, task);
        }
        this.addWorkflowToTaskMapping(connection, task);
        this.indexer.indexTask(task);
    }

    private Workflow readWorkflow(Connection connection, String workflowId) {
        String GET_WORKFLOW = "SELECT json_data FROM workflow WHERE workflow_id = ?";
        return this.query(connection, GET_WORKFLOW, q -> q.addParameter(workflowId).executeAndFetchFirst(Workflow.class));
    }

    private Workflow readWorkflowFromArchive(String workflowId) {
        String json = this.indexer.get(workflowId, RAW_JSON_FIELD);
        if (json != null) {
            return this.readValue(json, Workflow.class);
        }
        throw new ApplicationException(ApplicationException.Code.NOT_FOUND, "No such workflow found by id: " + workflowId);
    }

    private void addWorkflow(Connection connection, Workflow workflow) {
        String INSERT_WORKFLOW = "INSERT INTO workflow (workflow_id, correlation_id, json_data) VALUES (?, ?, ?)";
        this.execute(connection, INSERT_WORKFLOW, q -> q.addParameter(workflow.getWorkflowId()).addParameter(workflow.getCorrelationId()).addJsonParameter(workflow).executeUpdate());
    }

    private void updateWorkflow(Connection connection, Workflow workflow) {
        String UPDATE_WORKFLOW = "UPDATE workflow SET json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE workflow_id = ?";
        this.execute(connection, UPDATE_WORKFLOW, q -> q.addJsonParameter(workflow).addParameter(workflow.getWorkflowId()).executeUpdate());
    }

    private void removeWorkflow(Connection connection, String workflowId) {
        String REMOVE_WORKFLOW = "DELETE FROM workflow WHERE workflow_id = ?";
        this.execute(connection, REMOVE_WORKFLOW, q -> q.addParameter(workflowId).executeDelete());
    }

    private void addPendingWorkflow(Connection connection, String workflowType, String workflowId) {
        String EXISTS_PENDING_WORKFLOW = "SELECT EXISTS(SELECT 1 FROM workflow_pending WHERE workflow_type = ? AND workflow_id = ?)";
        boolean exist = this.query(connection, EXISTS_PENDING_WORKFLOW, q -> q.addParameter(workflowType).addParameter(workflowId).exists());
        if (!exist) {
            String INSERT_PENDING_WORKFLOW = "INSERT INTO workflow_pending (workflow_type, workflow_id) VALUES (?, ?)";
            this.execute(connection, INSERT_PENDING_WORKFLOW, q -> q.addParameter(workflowType).addParameter(workflowId).executeUpdate());
        }
    }

    private void removePendingWorkflow(Connection connection, String workflowType, String workflowId) {
        String REMOVE_PENDING_WORKFLOW = "DELETE FROM workflow_pending WHERE workflow_type = ? AND workflow_id = ?";
        this.execute(connection, REMOVE_PENDING_WORKFLOW, q -> q.addParameter(workflowType).addParameter(workflowId).executeDelete());
    }

    private void insertOrUpdateTaskData(Connection connection, Task task) {
        String INSERT_TASK = "INSERT INTO task (task_id, json_data, modified_on) VALUES (?, ?, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE json_data=VALUES(json_data), modified_on=VALUES(modified_on)";
        this.execute(connection, INSERT_TASK, q -> q.addParameter(task.getTaskId()).addJsonParameter(task).executeUpdate());
    }

    private void removeTaskData(Connection connection, Task task) {
        String REMOVE_TASK = "DELETE FROM task WHERE task_id = ?";
        this.execute(connection, REMOVE_TASK, q -> q.addParameter(task.getTaskId()).executeDelete());
    }

    private void addWorkflowToTaskMapping(Connection connection, Task task) {
        String EXISTS_WORKFLOW_TO_TASK = "SELECT EXISTS(SELECT 1 FROM workflow_to_task WHERE workflow_id = ? AND task_id = ?)";
        boolean exist = this.query(connection, EXISTS_WORKFLOW_TO_TASK, q -> q.addParameter(task.getWorkflowInstanceId()).addParameter(task.getTaskId()).exists());
        if (!exist) {
            String INSERT_WORKFLOW_TO_TASK = "INSERT INTO workflow_to_task (workflow_id, task_id) VALUES (?, ?)";
            this.execute(connection, INSERT_WORKFLOW_TO_TASK, q -> q.addParameter(task.getWorkflowInstanceId()).addParameter(task.getTaskId()).executeUpdate());
        }
    }

    private void removeWorkflowToTaskMapping(Connection connection, Task task) {
        String REMOVE_WORKFLOW_TO_TASK = "DELETE FROM workflow_to_task WHERE workflow_id = ? AND task_id = ?";
        this.execute(connection, REMOVE_WORKFLOW_TO_TASK, q -> q.addParameter(task.getWorkflowInstanceId()).addParameter(task.getTaskId()).executeDelete());
    }

    private void addWorkflowDefToWorkflowMapping(Connection connection, Workflow workflow) {
        String INSERT_WORKFLOW_DEF_TO_WORKFLOW = "INSERT INTO workflow_def_to_workflow (workflow_def, date_str, workflow_id) VALUES (?, ?, ?)";
        this.execute(connection, INSERT_WORKFLOW_DEF_TO_WORKFLOW, q -> q.addParameter(workflow.getWorkflowName()).addParameter(MySQLExecutionDAO.dateStr(workflow.getCreateTime())).addParameter(workflow.getWorkflowId()).executeUpdate());
    }

    private void removeWorkflowDefToWorkflowMapping(Connection connection, Workflow workflow) {
        String REMOVE_WORKFLOW_DEF_TO_WORKFLOW = "DELETE FROM workflow_def_to_workflow WHERE workflow_def = ? AND date_str = ? AND workflow_id = ?";
        this.execute(connection, REMOVE_WORKFLOW_DEF_TO_WORKFLOW, q -> q.addParameter(workflow.getWorkflowName()).addParameter(MySQLExecutionDAO.dateStr(workflow.getCreateTime())).addParameter(workflow.getWorkflowId()).executeUpdate());
    }

    private boolean addScheduledTask(Connection connection, Task task, String taskKey) {
        String EXISTS_SCHEDULED_TASK = "SELECT EXISTS(SELECT 1 FROM task_scheduled WHERE workflow_id = ? AND task_key = ?)";
        boolean exist = this.query(connection, EXISTS_SCHEDULED_TASK, q -> q.addParameter(task.getWorkflowInstanceId()).addParameter(taskKey).exists());
        if (!exist) {
            String INSERT_SCHEDULED_TASK = "INSERT INTO task_scheduled (workflow_id, task_key, task_id) VALUES (?, ?, ?)";
            this.execute(connection, INSERT_SCHEDULED_TASK, q -> q.addParameter(task.getWorkflowInstanceId()).addParameter(taskKey).addParameter(task.getTaskId()).executeUpdate());
            return true;
        }
        return false;
    }

    private void removeScheduledTask(Connection connection, Task task, String taskKey) {
        String REMOVE_SCHEDULED_TASK = "DELETE FROM task_scheduled WHERE workflow_id = ? AND task_key = ?";
        this.execute(connection, REMOVE_SCHEDULED_TASK, q -> q.addParameter(task.getWorkflowInstanceId()).addParameter(taskKey).executeDelete());
    }

    private void addTaskInProgress(Connection connection, Task task) {
        String EXISTS_IN_PROGRESS_TASK = "SELECT EXISTS(SELECT 1 FROM task_in_progress WHERE task_def_name = ? AND task_id = ?)";
        boolean exist = this.query(connection, EXISTS_IN_PROGRESS_TASK, q -> q.addParameter(task.getTaskDefName()).addParameter(task.getTaskId()).exists());
        if (!exist) {
            String INSERT_IN_PROGRESS_TASK = "INSERT INTO task_in_progress (task_def_name, task_id, workflow_id) VALUES (?, ?, ?)";
            this.execute(connection, INSERT_IN_PROGRESS_TASK, q -> q.addParameter(task.getTaskDefName()).addParameter(task.getTaskId()).addParameter(task.getWorkflowInstanceId()).executeUpdate());
        }
    }

    private void removeTaskInProgress(Connection connection, Task task) {
        String REMOVE_IN_PROGRESS_TASK = "DELETE FROM task_in_progress WHERE task_def_name = ? AND task_id = ?";
        this.execute(connection, REMOVE_IN_PROGRESS_TASK, q -> q.addParameter(task.getTaskDefName()).addParameter(task.getTaskId()).executeUpdate());
    }

    private void updateInProgressStatus(Connection connection, Task task, boolean inProgress) {
        String UPDATE_IN_PROGRESS_TASK_STATUS = "UPDATE task_in_progress SET in_progress_status = ?, modified_on = CURRENT_TIMESTAMP WHERE task_def_name = ? AND task_id = ?";
        this.execute(connection, UPDATE_IN_PROGRESS_TASK_STATUS, q -> q.addParameter(inProgress).addParameter(task.getTaskDefName()).addParameter(task.getTaskId()).executeUpdate());
    }

    private boolean insertEventExecution(Connection connection, EventExecution eventExecution) {
        String EXISTS_EVENT_EXECUTION = "SELECT EXISTS(SELECT 1 FROM event_execution WHERE event_handler_name = ? AND event_name = ? AND message_id = ? AND execution_id = ?)";
        boolean exist = this.query(connection, EXISTS_EVENT_EXECUTION, q -> q.addParameter(eventExecution.getName()).addParameter(eventExecution.getEvent()).addParameter(eventExecution.getMessageId()).addParameter(eventExecution.getId()).exists());
        if (!exist) {
            String INSERT_EVENT_EXECUTION = "INSERT INTO event_execution (event_handler_name, event_name, message_id, execution_id, json_data) VALUES (?, ?, ?, ?, ?)";
            this.execute(connection, INSERT_EVENT_EXECUTION, q -> q.addParameter(eventExecution.getName()).addParameter(eventExecution.getEvent()).addParameter(eventExecution.getMessageId()).addParameter(eventExecution.getId()).addJsonParameter(eventExecution).executeUpdate());
        }
        return false;
    }

    private void updateEventExecution(Connection connection, EventExecution eventExecution) {
        String UPDATE_EVENT_EXECUTION = "UPDATE event_execution SET json_data = ?, modified_on = CURRENT_TIMESTAMP WHERE event_handler_name = ? AND event_name = ? AND message_id = ? AND execution_id = ?";
        this.execute(connection, UPDATE_EVENT_EXECUTION, q -> q.addJsonParameter(eventExecution).addParameter(eventExecution.getName()).addParameter(eventExecution.getEvent()).addParameter(eventExecution.getMessageId()).addParameter(eventExecution.getId()).executeUpdate());
    }

    private void removeEventExecution(Connection connection, EventExecution eventExecution) {
        String REMOVE_EVENT_EXECUTION = "DELETE FROM event_execution WHERE event_handler_name = ? AND event_name = ? AND message_id = ? AND execution_id = ?";
        this.execute(connection, REMOVE_EVENT_EXECUTION, q -> q.addParameter(eventExecution.getName()).addParameter(eventExecution.getEvent()).addParameter(eventExecution.getMessageId()).addParameter(eventExecution.getId()).executeUpdate());
    }

    private EventExecution readEventExecution(Connection connection, String eventHandlerName, String eventName, String messageId, String executionId) {
        String GET_EVENT_EXECUTION = "SELECT json_data FROM event_execution WHERE event_handler_name = ? AND event_name = ? AND message_id = ? AND execution_id = ?";
        return this.query(connection, GET_EVENT_EXECUTION, q -> q.addParameter(eventHandlerName).addParameter(eventName).addParameter(messageId).addParameter(executionId).executeAndFetchFirst(EventExecution.class));
    }

    private void insertOrUpdatePollData(Connection connection, PollData pollData, String domain) {
        String INSERT_POLL_DATA = "INSERT INTO poll_data (queue_name, domain, json_data, modified_on) VALUES (?, ?, ?, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE json_data=VALUES(json_data), modified_on=VALUES(modified_on)";
        this.execute(connection, INSERT_POLL_DATA, q -> q.addParameter(pollData.getQueueName()).addParameter(domain).addJsonParameter(pollData).executeUpdate());
    }

    private PollData readPollData(Connection connection, String queueName, String domain) {
        String GET_POLL_DATA = "SELECT json_data FROM poll_data WHERE queue_name = ? AND domain = ?";
        return this.query(connection, GET_POLL_DATA, q -> q.addParameter(queueName).addParameter(domain).executeAndFetchFirst(PollData.class));
    }

    private List<PollData> readAllPollData(String queueName) {
        String GET_ALL_POLL_DATA = "SELECT json_data FROM poll_data WHERE queue_name = ?";
        return this.queryWithTransaction(GET_ALL_POLL_DATA, q -> q.addParameter(queueName).executeAndFetch(PollData.class));
    }

    private List<String> findAllTasksInProgressInOrderOfArrival(Task task, int limit) {
        String GET_IN_PROGRESS_TASKS_WITH_LIMIT = "SELECT task_id FROM task_in_progress WHERE task_def_name = ? ORDER BY id LIMIT ?";
        return this.queryWithTransaction(GET_IN_PROGRESS_TASKS_WITH_LIMIT, q -> q.addParameter(task.getTaskDefName()).addParameter(limit).executeScalarList(String.class));
    }

    private void validate(Task task) {
        Preconditions.checkNotNull((Object)task, (Object)"task object cannot be null");
        Preconditions.checkNotNull((Object)task.getTaskId(), (Object)"Task id cannot be null");
        Preconditions.checkNotNull((Object)task.getWorkflowInstanceId(), (Object)"Workflow instance id cannot be null");
        Preconditions.checkNotNull((Object)task.getReferenceTaskName(), (Object)"Task reference name cannot be null");
    }
}

