/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.conductor.mysql.MySQLConfiguration;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataSourceProvider
implements Provider<DataSource> {
    private static final Logger logger = LoggerFactory.getLogger(MySQLDataSourceProvider.class);
    private final MySQLConfiguration configuration;

    @Inject
    public MySQLDataSourceProvider(MySQLConfiguration configuration) {
        this.configuration = configuration;
    }

    public DataSource get() {
        HikariDataSource dataSource = null;
        try {
            dataSource = new HikariDataSource(this.createConfiguration());
            this.flywayMigrate((DataSource)dataSource);
            return dataSource;
        }
        catch (Throwable t) {
            if (null != dataSource && !dataSource.isClosed()) {
                dataSource.close();
            }
            logger.error("error migration DB", t);
            throw t;
        }
    }

    private HikariConfig createConfiguration() {
        HikariConfig cfg = new HikariConfig();
        cfg.setJdbcUrl(this.configuration.getJdbcUrl());
        cfg.setUsername(this.configuration.getJdbcUserName());
        cfg.setPassword(this.configuration.getJdbcPassword());
        cfg.setAutoCommit(false);
        cfg.setMaximumPoolSize(this.configuration.getConnectionPoolMaxSize());
        cfg.setMinimumIdle(this.configuration.getConnectionPoolMinIdle());
        cfg.setMaxLifetime(this.configuration.getConnectionMaxLifetime());
        cfg.setIdleTimeout(this.configuration.getConnectionIdleTimeout());
        cfg.setConnectionTimeout(this.configuration.getConnectionTimeout());
        cfg.setTransactionIsolation(this.configuration.getTransactionIsolationLevel());
        cfg.setAutoCommit(this.configuration.isAutoCommit());
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hikari-mysql-%d").build();
        cfg.setThreadFactory(tf);
        return cfg;
    }

    private void flywayMigrate(DataSource dataSource) {
        boolean enabled = this.configuration.isFlywayEnabled();
        if (!enabled) {
            logger.debug("Flyway migrations are disabled");
            return;
        }
        Flyway flyway = new Flyway();
        this.configuration.getFlywayTable().ifPresent(tableName -> {
            logger.debug("Using Flyway migration table '{}'", tableName);
            flyway.setTable(tableName);
        });
        flyway.setDataSource(dataSource);
        flyway.setPlaceholderReplacement(false);
        flyway.migrate();
    }
}

