/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql;

import com.netflix.conductor.core.config.Configuration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public interface MySQLConfiguration
extends Configuration {
    public static final String JDBC_URL_PROPERTY_NAME = "jdbc.url";
    public static final String JDBC_URL_DEFAULT_VALUE = "jdbc:mysql://localhost:3306/conductor";
    public static final String JDBC_USER_NAME_PROPERTY_NAME = "jdbc.username";
    public static final String JDBC_USER_NAME_DEFAULT_VALUE = "conductor";
    public static final String JDBC_PASSWORD_PROPERTY_NAME = "jdbc.password";
    public static final String JDBC_PASSWORD_DEFAULT_VALUE = "password";
    public static final String FLYWAY_ENABLED_PROPERTY_NAME = "flyway.enabled";
    public static final boolean FLYWAY_ENABLED_DEFAULT_VALUE = true;
    public static final String FLYWAY_TABLE_PROPERTY_NAME = "flyway.table";
    public static final Optional<String> FLYWAY_TABLE_DEFAULT_VALUE = Optional.empty();
    public static final String CONNECTION_POOL_MAX_SIZE_PROPERTY_NAME = "conductor.mysql.connection.pool.size.max";
    public static final int CONNECTION_POOL_MAX_SIZE_DEFAULT_VALUE = -1;
    public static final String CONNECTION_POOL_MINIMUM_IDLE_PROPERTY_NAME = "conductor.mysql.connection.pool.idle.min";
    public static final int CONNECTION_POOL_MINIMUM_IDLE_DEFAULT_VALUE = -1;
    public static final String CONNECTION_MAX_LIFETIME_PROPERTY_NAME = "conductor.mysql.connection.lifetime.max";
    public static final long CONNECTION_MAX_LIFETIME_DEFAULT_VALUE = TimeUnit.MINUTES.toMillis(30L);
    public static final String CONNECTION_IDLE_TIMEOUT_PROPERTY_NAME = "conductor.mysql.connection.idle.timeout";
    public static final long CONNECTION_IDLE_TIMEOUT_DEFAULT_VALUE = TimeUnit.MINUTES.toMillis(10L);
    public static final String CONNECTION_TIMEOUT_PROPERTY_NAME = "conductor.mysql.connection.timeout";
    public static final long CONNECTION_TIMEOUT_DEFAULT_VALUE = TimeUnit.SECONDS.toMillis(30L);
    public static final String ISOLATION_LEVEL_PROPERTY_NAME = "conductor.mysql.transaction.isolation.level";
    public static final String ISOLATION_LEVEL_DEFAULT_VALUE = "";
    public static final String AUTO_COMMIT_PROPERTY_NAME = "conductor.mysql.autocommit";
    public static final boolean AUTO_COMMIT_DEFAULT_VALUE = false;

    default public String getJdbcUrl() {
        return this.getProperty(JDBC_URL_PROPERTY_NAME, JDBC_URL_DEFAULT_VALUE);
    }

    default public String getJdbcUserName() {
        return this.getProperty(JDBC_USER_NAME_PROPERTY_NAME, JDBC_USER_NAME_DEFAULT_VALUE);
    }

    default public String getJdbcPassword() {
        return this.getProperty(JDBC_PASSWORD_PROPERTY_NAME, JDBC_PASSWORD_DEFAULT_VALUE);
    }

    default public boolean isFlywayEnabled() {
        return this.getBoolProperty(FLYWAY_ENABLED_PROPERTY_NAME, true);
    }

    default public Optional<String> getFlywayTable() {
        return Optional.ofNullable(this.getProperty(FLYWAY_TABLE_PROPERTY_NAME, null));
    }

    default public int getConnectionPoolMaxSize() {
        return this.getIntProperty(CONNECTION_POOL_MAX_SIZE_PROPERTY_NAME, -1);
    }

    default public int getConnectionPoolMinIdle() {
        return this.getIntProperty(CONNECTION_POOL_MINIMUM_IDLE_PROPERTY_NAME, -1);
    }

    default public long getConnectionMaxLifetime() {
        return this.getLongProperty(CONNECTION_MAX_LIFETIME_PROPERTY_NAME, CONNECTION_MAX_LIFETIME_DEFAULT_VALUE);
    }

    default public long getConnectionIdleTimeout() {
        return this.getLongProperty(CONNECTION_IDLE_TIMEOUT_PROPERTY_NAME, CONNECTION_IDLE_TIMEOUT_DEFAULT_VALUE);
    }

    default public long getConnectionTimeout() {
        return this.getLongProperty(CONNECTION_TIMEOUT_PROPERTY_NAME, CONNECTION_TIMEOUT_DEFAULT_VALUE);
    }

    default public String getTransactionIsolationLevel() {
        return this.getProperty(ISOLATION_LEVEL_PROPERTY_NAME, ISOLATION_LEVEL_DEFAULT_VALUE);
    }

    default public boolean isAutoCommit() {
        return this.getBoolProperty(AUTO_COMMIT_PROPERTY_NAME, false);
    }
}

