/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.dao.ExecutionDAO;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.dao.QueueDAO;
import com.netflix.conductor.mysql.config.MySQLDataSourceProvider;
import com.netflix.conductor.mysql.config.MySQLProperties;
import com.netflix.conductor.mysql.dao.MySQLExecutionDAO;
import com.netflix.conductor.mysql.dao.MySQLMetadataDAO;
import com.netflix.conductor.mysql.dao.MySQLQueueDAO;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MySQLProperties.class})
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="mysql")
public class MySQLConfiguration {
    @Bean
    public DataSource dataSource(MySQLProperties properties) {
        return new MySQLDataSourceProvider(properties).getDataSource();
    }

    @Bean
    public MetadataDAO mySqlMetadataDAO(ObjectMapper objectMapper, DataSource dataSource, MySQLProperties properties) {
        return new MySQLMetadataDAO(objectMapper, dataSource, properties);
    }

    @Bean
    public ExecutionDAO mySqlExecutionDAO(ObjectMapper objectMapper, DataSource dataSource) {
        return new MySQLExecutionDAO(objectMapper, dataSource);
    }

    @Bean
    public QueueDAO mySqlQueueDAO(ObjectMapper objectMapper, DataSource dataSource) {
        return new MySQLQueueDAO(objectMapper, dataSource);
    }
}

