/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="conductor.mysql")
public class MySQLProperties {
    private String jdbcUrl = "jdbc:mysql://localhost:3306/conductor";
    private String jdbcUsername = "conductor";
    private String jdbcPassword = "password";
    private boolean flywayEnabled = true;
    private String flywayTable = "schema_version";
    private int connectionPoolMaxSize = -1;
    private int connectionPoolMinIdle = -1;
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration connectionMaxLifetime = Duration.ofMinutes(30L);
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration connectionIdleTimeout = Duration.ofMinutes(10L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration connectionTimeout = Duration.ofSeconds(30L);
    private String transactionIsolationLevel = "";
    private boolean autoCommit = false;
    private Duration taskDefCacheRefreshInterval = Duration.ofSeconds(60L);

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public boolean isFlywayEnabled() {
        return this.flywayEnabled;
    }

    public void setFlywayEnabled(boolean flywayEnabled) {
        this.flywayEnabled = flywayEnabled;
    }

    public String getFlywayTable() {
        return this.flywayTable;
    }

    public void setFlywayTable(String flywayTable) {
        this.flywayTable = flywayTable;
    }

    public int getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    public void setConnectionPoolMaxSize(int connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
    }

    public int getConnectionPoolMinIdle() {
        return this.connectionPoolMinIdle;
    }

    public void setConnectionPoolMinIdle(int connectionPoolMinIdle) {
        this.connectionPoolMinIdle = connectionPoolMinIdle;
    }

    public Duration getConnectionMaxLifetime() {
        return this.connectionMaxLifetime;
    }

    public void setConnectionMaxLifetime(Duration connectionMaxLifetime) {
        this.connectionMaxLifetime = connectionMaxLifetime;
    }

    public Duration getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public void setConnectionIdleTimeout(Duration connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(String transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public Duration getTaskDefCacheRefreshInterval() {
        return this.taskDefCacheRefreshInterval;
    }

    public void setTaskDefCacheRefreshInterval(Duration taskDefCacheRefreshInterval) {
        this.taskDefCacheRefreshInterval = taskDefCacheRefreshInterval;
    }
}

