/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.netflix.conductor.common.utils.RetryUtil;
import com.netflix.conductor.core.exception.ApplicationException;
import com.netflix.conductor.mysql.util.ExecuteFunction;
import com.netflix.conductor.mysql.util.LazyToString;
import com.netflix.conductor.mysql.util.Query;
import com.netflix.conductor.mysql.util.QueryFunction;
import com.netflix.conductor.mysql.util.TransactionalFunction;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MySQLBaseDAO {
    private static final String MAX_RETRY_ON_DEADLOCK_PROPERTY_NAME = "conductor.mysql.deadlock.retry.max";
    private static final String MAX_RETRY_ON_DEADLOCK_PROPERTY_DEFAULT_VALUE = "3";
    private static final int MAX_RETRY_ON_DEADLOCK = MySQLBaseDAO.getMaxRetriesOnDeadLock();
    private static final List<String> EXCLUDED_STACKTRACE_CLASS = ImmutableList.of((Object)MySQLBaseDAO.class.getName(), (Object)Thread.class.getName());
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper objectMapper;
    protected final DataSource dataSource;

    protected MySQLBaseDAO(ObjectMapper om, DataSource dataSource) {
        this.objectMapper = om;
        this.dataSource = dataSource;
    }

    protected final LazyToString getCallingMethod() {
        return new LazyToString(() -> Arrays.stream(Thread.currentThread().getStackTrace()).filter(ste -> !EXCLUDED_STACKTRACE_CLASS.contains(ste.getClassName())).findFirst().map(StackTraceElement::getMethodName).orElseThrow(() -> new NullPointerException("Cannot find Caller")));
    }

    protected String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException ex) {
            throw new ApplicationException(ApplicationException.Code.INTERNAL_ERROR, (Throwable)ex);
        }
    }

    protected <T> T readValue(String json, Class<T> tClass) {
        try {
            return (T)this.objectMapper.readValue(json, tClass);
        }
        catch (IOException ex) {
            throw new ApplicationException(ApplicationException.Code.INTERNAL_ERROR, (Throwable)ex);
        }
    }

    protected <T> T readValue(String json, TypeReference<T> typeReference) {
        try {
            return (T)this.objectMapper.readValue(json, typeReference);
        }
        catch (IOException ex) {
            throw new ApplicationException(ApplicationException.Code.INTERNAL_ERROR, (Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R getWithTransaction(TransactionalFunction<R> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    <R> R getWithRetriedTransactions(TransactionalFunction<R> function) {
        try {
            return (R)new RetryUtil().retryOnException(() -> this.getWithTransaction(function), this::isDeadLockError, null, MAX_RETRY_ON_DEADLOCK, "retry on deadlock", "transactional");
        }
        catch (RuntimeException e) {
            throw (ApplicationException)e.getCause();
        }
    }

    /*
     * Exception decompiling
     */
    protected <R> R getWithTransactionWithOutErrorPropagation(TransactionalFunction<R> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void withTransaction(Consumer<Connection> consumer) {
        this.getWithRetriedTransactions(connection -> {
            consumer.accept(connection);
            return null;
        });
    }

    protected <R> R queryWithTransaction(String query, QueryFunction<R> function) {
        return (R)this.getWithRetriedTransactions(tx -> this.query(tx, query, function));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R query(Connection tx, String query, QueryFunction<R> function) {
        try (Query q = new Query(this.objectMapper, tx, query);){
            R r = function.apply(q);
            return r;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    protected void execute(Connection tx, String query, ExecuteFunction function) {
        try (Query q = new Query(this.objectMapper, tx, query);){
            function.apply(q);
        }
        catch (SQLException ex) {
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, (Throwable)ex);
        }
    }

    protected void executeWithTransaction(String query, ExecuteFunction function) {
        this.withTransaction(tx -> this.execute((Connection)tx, query, function));
    }

    private boolean isDeadLockError(Throwable throwable) {
        SQLException sqlException = this.findCauseSQLException(throwable);
        if (sqlException == null) {
            return false;
        }
        return 1213 == sqlException.getErrorCode();
    }

    private SQLException findCauseSQLException(Throwable throwable) {
        Throwable causeException;
        for (causeException = throwable; null != causeException && !(causeException instanceof SQLException); causeException = causeException.getCause()) {
        }
        return (SQLException)causeException;
    }

    private static int getMaxRetriesOnDeadLock() {
        try {
            return Integer.parseInt(System.getProperty(MAX_RETRY_ON_DEADLOCK_PROPERTY_NAME, MAX_RETRY_ON_DEADLOCK_PROPERTY_DEFAULT_VALUE));
        }
        catch (Exception e) {
            return Integer.parseInt(MAX_RETRY_ON_DEADLOCK_PROPERTY_DEFAULT_VALUE);
        }
    }
}

