/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.conductor.mysql.config.MySQLProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.ThreadFactory;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataSourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDataSourceProvider.class);
    private final MySQLProperties properties;

    public MySQLDataSourceProvider(MySQLProperties properties) {
        this.properties = properties;
    }

    public DataSource getDataSource() {
        HikariDataSource dataSource = null;
        try {
            dataSource = new HikariDataSource(this.createConfiguration());
            this.flywayMigrate((DataSource)dataSource);
            return dataSource;
        }
        catch (Throwable t) {
            if (null != dataSource && !dataSource.isClosed()) {
                dataSource.close();
            }
            LOGGER.error("error migration DB", t);
            throw t;
        }
    }

    private HikariConfig createConfiguration() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.properties.getJdbcUrl());
        hikariConfig.setUsername(this.properties.getJdbcUsername());
        hikariConfig.setPassword(this.properties.getJdbcPassword());
        hikariConfig.setAutoCommit(false);
        hikariConfig.setMaximumPoolSize(this.properties.getConnectionPoolMaxSize());
        hikariConfig.setMinimumIdle(this.properties.getConnectionPoolMinIdle());
        hikariConfig.setMaxLifetime(this.properties.getConnectionMaxLifetime().toMillis());
        hikariConfig.setIdleTimeout(this.properties.getConnectionIdleTimeout().toMillis());
        hikariConfig.setConnectionTimeout(this.properties.getConnectionTimeout().toMillis());
        hikariConfig.setTransactionIsolation(this.properties.getTransactionIsolationLevel());
        hikariConfig.setAutoCommit(this.properties.isAutoCommit());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hikari-mysql-%d").build();
        hikariConfig.setThreadFactory(threadFactory);
        return hikariConfig;
    }

    private void flywayMigrate(DataSource dataSource) {
        boolean enabled = this.properties.isFlywayEnabled();
        if (!enabled) {
            LOGGER.debug("Flyway migrations are disabled");
            return;
        }
        String flywayTable = this.properties.getFlywayTable();
        LOGGER.debug("Using Flyway migration table '{}'", (Object)flywayTable);
        FluentConfiguration fluentConfiguration = Flyway.configure().table(flywayTable).dataSource(dataSource).placeholderReplacement(false);
        Flyway flyway = fluentConfiguration.load();
        flyway.migrate();
    }
}

