/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.dao.ExecutionDAO;
import com.netflix.conductor.dao.MetadataDAO;
import com.netflix.conductor.dao.QueueDAO;
import com.netflix.conductor.mysql.config.MySQLProperties;
import com.netflix.conductor.mysql.dao.MySQLExecutionDAO;
import com.netflix.conductor.mysql.dao.MySQLMetadataDAO;
import com.netflix.conductor.mysql.dao.MySQLQueueDAO;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MySQLProperties.class})
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="mysql")
@Import(value={DataSourceAutoConfiguration.class})
public class MySQLConfiguration {
    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    public MetadataDAO mySqlMetadataDAO(ObjectMapper objectMapper, DataSource dataSource, MySQLProperties properties) {
        return new MySQLMetadataDAO(objectMapper, dataSource, properties);
    }

    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    public ExecutionDAO mySqlExecutionDAO(ObjectMapper objectMapper, DataSource dataSource) {
        return new MySQLExecutionDAO(objectMapper, dataSource);
    }

    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    public QueueDAO mySqlQueueDAO(ObjectMapper objectMapper, DataSource dataSource) {
        return new MySQLQueueDAO(objectMapper, dataSource);
    }
}

