/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.mysql.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.mysql.config.MySQLProperties;
import com.netflix.conductor.mysql.dao.MySQLExecutionDAO;
import com.netflix.conductor.mysql.dao.MySQLMetadataDAO;
import com.netflix.conductor.mysql.dao.MySQLQueueDAO;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MySQLProperties.class})
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="mysql")
@Import(value={DataSourceAutoConfiguration.class})
public class MySQLConfiguration {
    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    public MySQLMetadataDAO mySqlMetadataDAO(@Qualifier(value="mysqlRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper, DataSource dataSource, MySQLProperties properties) {
        return new MySQLMetadataDAO(retryTemplate, objectMapper, dataSource, properties);
    }

    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    public MySQLExecutionDAO mySqlExecutionDAO(@Qualifier(value="mysqlRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper, DataSource dataSource) {
        return new MySQLExecutionDAO(retryTemplate, objectMapper, dataSource);
    }

    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    public MySQLQueueDAO mySqlQueueDAO(@Qualifier(value="mysqlRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper, DataSource dataSource) {
        return new MySQLQueueDAO(retryTemplate, objectMapper, dataSource);
    }

    @Bean
    public RetryTemplate mysqlRetryTemplate(MySQLProperties properties) {
        CustomRetryPolicy retryPolicy = new CustomRetryPolicy();
        retryPolicy.setMaxAttempts(properties.getDeadlockRetryMax());
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setBackOffPolicy((BackOffPolicy)new NoBackOffPolicy());
        return retryTemplate;
    }

    public static class CustomRetryPolicy
    extends SimpleRetryPolicy {
        public boolean canRetry(RetryContext context) {
            Optional<Throwable> lastThrowable = Optional.ofNullable(context.getLastThrowable());
            return lastThrowable.map(throwable -> super.canRetry(context) && this.isDeadLockError((Throwable)throwable)).orElseGet(() -> super.canRetry(context));
        }

        private boolean isDeadLockError(Throwable throwable) {
            SQLException sqlException = this.findCauseSQLException(throwable);
            if (sqlException == null) {
                return false;
            }
            return 1213 == sqlException.getErrorCode();
        }

        private SQLException findCauseSQLException(Throwable throwable) {
            Throwable causeException;
            for (causeException = throwable; null != causeException && !(causeException instanceof SQLException); causeException = causeException.getCause()) {
            }
            return (SQLException)causeException;
        }
    }
}

