/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.postgres.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.postgres.config.PostgresProperties;
import com.netflix.conductor.postgres.dao.PostgresExecutionDAO;
import com.netflix.conductor.postgres.dao.PostgresIndexDAO;
import com.netflix.conductor.postgres.dao.PostgresMetadataDAO;
import com.netflix.conductor.postgres.dao.PostgresQueueDAO;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={PostgresProperties.class})
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="postgres")
@Import(value={DataSourceAutoConfiguration.class})
public class PostgresConfiguration {
    DataSource dataSource;
    private final PostgresProperties properties;

    public PostgresConfiguration(DataSource dataSource, PostgresProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @Bean(initMethod="migrate")
    @PostConstruct
    public Flyway flywayForPrimaryDb() {
        return Flyway.configure().locations(new String[]{"classpath:db/migration_postgres"}).schemas(new String[]{this.properties.getSchema()}).dataSource(this.dataSource).baselineOnMigrate(true).load();
    }

    @Bean
    @DependsOn(value={"flywayForPrimaryDb"})
    public PostgresMetadataDAO postgresMetadataDAO(@Qualifier(value="postgresRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper, PostgresProperties properties) {
        return new PostgresMetadataDAO(retryTemplate, objectMapper, this.dataSource, properties);
    }

    @Bean
    @DependsOn(value={"flywayForPrimaryDb"})
    public PostgresExecutionDAO postgresExecutionDAO(@Qualifier(value="postgresRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper) {
        return new PostgresExecutionDAO(retryTemplate, objectMapper, this.dataSource);
    }

    @Bean
    @DependsOn(value={"flywayForPrimaryDb"})
    public PostgresQueueDAO postgresQueueDAO(@Qualifier(value="postgresRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper) {
        return new PostgresQueueDAO(retryTemplate, objectMapper, this.dataSource);
    }

    @Bean
    @DependsOn(value={"flywayForPrimaryDb"})
    @ConditionalOnProperty(name={"conductor.indexing.type"}, havingValue="postgres")
    public PostgresIndexDAO postgresIndexDAO(@Qualifier(value="postgresRetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper) {
        return new PostgresIndexDAO(retryTemplate, objectMapper, this.dataSource);
    }

    @Bean
    public RetryTemplate postgresRetryTemplate(PostgresProperties properties) {
        CustomRetryPolicy retryPolicy = new CustomRetryPolicy();
        retryPolicy.setMaxAttempts(3);
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setBackOffPolicy((BackOffPolicy)new NoBackOffPolicy());
        return retryTemplate;
    }

    public static class CustomRetryPolicy
    extends SimpleRetryPolicy {
        private static final String ER_LOCK_DEADLOCK = "40P01";
        private static final String ER_SERIALIZATION_FAILURE = "40001";

        public boolean canRetry(RetryContext context) {
            Optional<Throwable> lastThrowable = Optional.ofNullable(context.getLastThrowable());
            return lastThrowable.map(throwable -> super.canRetry(context) && this.isDeadLockError((Throwable)throwable)).orElseGet(() -> super.canRetry(context));
        }

        private boolean isDeadLockError(Throwable throwable) {
            SQLException sqlException = this.findCauseSQLException(throwable);
            if (sqlException == null) {
                return false;
            }
            return ER_LOCK_DEADLOCK.equals(sqlException.getSQLState()) || ER_SERIALIZATION_FAILURE.equals(sqlException.getSQLState());
        }

        private SQLException findCauseSQLException(Throwable throwable) {
            Throwable causeException;
            for (causeException = throwable; null != causeException && !(causeException instanceof SQLException); causeException = causeException.getCause()) {
            }
            return (SQLException)causeException;
        }
    }
}

