/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.postgres.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.common.metadata.events.EventExecution;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.core.events.queue.Message;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.postgres.dao.PostgresBaseDAO;
import com.netflix.conductor.postgres.util.PostgresIndexQueryBuilder;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.springframework.retry.support.RetryTemplate;

public class PostgresIndexDAO
extends PostgresBaseDAO
implements IndexDAO {
    public PostgresIndexDAO(RetryTemplate retryTemplate, ObjectMapper objectMapper, DataSource dataSource) {
        super(retryTemplate, objectMapper, dataSource);
    }

    public void indexWorkflow(WorkflowSummary workflow) {
        String INSERT_WORKFLOW_INDEX_SQL = "INSERT INTO workflow_index (workflow_id, correlation_id, workflow_type, start_time, status, json_data)VALUES (?, ?, ?, ?, ?, ?::JSONB) ON CONFLICT (workflow_id) \nDO UPDATE SET correlation_id = EXCLUDED.correlation_id, workflow_type = EXCLUDED.workflow_type, start_time = EXCLUDED.start_time, status = EXCLUDED.status, json_data = EXCLUDED.json_data";
        TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(workflow.getStartTime());
        Timestamp startTime = Timestamp.from(Instant.from(ta));
        this.queryWithTransaction(INSERT_WORKFLOW_INDEX_SQL, q -> q.addParameter(workflow.getWorkflowId()).addParameter(workflow.getCorrelationId()).addParameter(workflow.getWorkflowType()).addParameter(startTime).addParameter(workflow.getStatus().toString()).addJsonParameter(workflow).executeUpdate());
    }

    public SearchResult<WorkflowSummary> searchWorkflowSummary(String query, String freeText, int start, int count, List<String> sort) {
        PostgresIndexQueryBuilder queryBuilder = new PostgresIndexQueryBuilder("workflow_index", query, freeText, start, count, sort);
        List results = this.queryWithTransaction(queryBuilder.getQuery(), q -> {
            queryBuilder.addParameters(q);
            return q.executeAndFetch(WorkflowSummary.class);
        });
        int totalHits = results.size() == count ? start + count + 1 : start + results.size();
        return new SearchResult((long)totalHits, results);
    }

    public void indexTask(TaskSummary task) {
        String INSERT_TASK_INDEX_SQL = "INSERT INTO task_index (task_id, task_type, task_def_name, status, start_time, update_time, workflow_type, json_data)VALUES (?, ?, ?, ?, ?, ?, ?, ?::JSONB) ON CONFLICT (task_id) DO UPDATE SET task_type = EXCLUDED.task_type, task_def_name = EXCLUDED.task_def_name, status = EXCLUDED.status, update_time = EXCLUDED.update_time, json_data = EXCLUDED.json_data";
        TemporalAccessor updateTa = DateTimeFormatter.ISO_INSTANT.parse(task.getUpdateTime());
        Timestamp updateTime = Timestamp.from(Instant.from(updateTa));
        TemporalAccessor startTa = DateTimeFormatter.ISO_INSTANT.parse(task.getStartTime());
        Timestamp startTime = Timestamp.from(Instant.from(startTa));
        this.queryWithTransaction(INSERT_TASK_INDEX_SQL, q -> q.addParameter(task.getTaskId()).addParameter(task.getTaskType()).addParameter(task.getTaskDefName()).addParameter(task.getStatus().toString()).addParameter(startTime).addParameter(updateTime).addParameter(task.getWorkflowType()).addJsonParameter(task).executeUpdate());
    }

    public SearchResult<TaskSummary> searchTaskSummary(String query, String freeText, int start, int count, List<String> sort) {
        PostgresIndexQueryBuilder queryBuilder = new PostgresIndexQueryBuilder("task_index", query, freeText, start, count, sort);
        List results = this.queryWithTransaction(queryBuilder.getQuery(), q -> {
            queryBuilder.addParameters(q);
            return q.executeAndFetch(TaskSummary.class);
        });
        int totalHits = results.size() == count ? start + count + 1 : start + results.size();
        return new SearchResult((long)totalHits, results);
    }

    public void addTaskExecutionLogs(List<TaskExecLog> logs) {
        String INSERT_LOG = "INSERT INTO task_execution_logs (task_id, created_time, log) VALUES (?, ?, ?)";
        for (TaskExecLog log : logs) {
            this.queryWithTransaction(INSERT_LOG, q -> q.addParameter(log.getTaskId()).addParameter(new Timestamp(log.getCreatedTime())).addParameter(log.getLog()).executeUpdate());
        }
    }

    public List<TaskExecLog> getTaskExecutionLogs(String taskId) {
        return this.queryWithTransaction("SELECT log, task_id, created_time FROM task_execution_logs WHERE task_id = ? ORDER BY created_time ASC", q -> q.addParameter(taskId).executeAndFetch(rs -> {
            ArrayList<TaskExecLog> result = new ArrayList<TaskExecLog>();
            while (rs.next()) {
                TaskExecLog log = new TaskExecLog();
                log.setLog(rs.getString("log"));
                log.setTaskId(rs.getString("task_id"));
                log.setCreatedTime(rs.getDate("created_time").getTime());
                result.add(log);
            }
            return result;
        }));
    }

    public void setup() {
    }

    public CompletableFuture<Void> asyncIndexWorkflow(WorkflowSummary workflow) {
        this.logger.info("asyncIndexWorkflow is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> asyncIndexTask(TaskSummary task) {
        this.logger.info("asyncIndexTask is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public SearchResult<String> searchWorkflows(String query, String freeText, int start, int count, List<String> sort) {
        this.logger.info("searchWorkflows is not supported for postgres indexing");
        return null;
    }

    public SearchResult<String> searchTasks(String query, String freeText, int start, int count, List<String> sort) {
        this.logger.info("searchTasks is not supported for postgres indexing");
        return null;
    }

    public void removeWorkflow(String workflowId) {
        this.logger.info("removeWorkflow is not supported for postgres indexing");
    }

    public CompletableFuture<Void> asyncRemoveWorkflow(String workflowId) {
        this.logger.info("asyncRemoveWorkflow is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public void updateWorkflow(String workflowInstanceId, String[] keys, Object[] values) {
        this.logger.info("updateWorkflow is not supported for postgres indexing");
    }

    public CompletableFuture<Void> asyncUpdateWorkflow(String workflowInstanceId, String[] keys, Object[] values) {
        this.logger.info("asyncUpdateWorkflow is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public void removeTask(String workflowId, String taskId) {
        this.logger.info("removeTask is not supported for postgres indexing");
    }

    public CompletableFuture<Void> asyncRemoveTask(String workflowId, String taskId) {
        this.logger.info("asyncRemoveTask is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public void updateTask(String workflowId, String taskId, String[] keys, Object[] values) {
        this.logger.info("updateTask is not supported for postgres indexing");
    }

    public CompletableFuture<Void> asyncUpdateTask(String workflowId, String taskId, String[] keys, Object[] values) {
        this.logger.info("asyncUpdateTask is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public String get(String workflowInstanceId, String key) {
        this.logger.info("get is not supported for postgres indexing");
        return null;
    }

    public CompletableFuture<Void> asyncAddTaskExecutionLogs(List<TaskExecLog> logs) {
        this.logger.info("asyncAddTaskExecutionLogs is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public void addEventExecution(EventExecution eventExecution) {
        this.logger.info("addEventExecution is not supported for postgres indexing");
    }

    public List<EventExecution> getEventExecutions(String event) {
        this.logger.info("getEventExecutions is not supported for postgres indexing");
        return null;
    }

    public CompletableFuture<Void> asyncAddEventExecution(EventExecution eventExecution) {
        this.logger.info("asyncAddEventExecution is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public void addMessage(String queue, Message msg) {
        this.logger.info("addMessage is not supported for postgres indexing");
    }

    public CompletableFuture<Void> asyncAddMessage(String queue, Message message) {
        this.logger.info("asyncAddMessage is not supported for postgres indexing");
        return CompletableFuture.completedFuture(null);
    }

    public List<Message> getMessages(String queue) {
        this.logger.info("getMessages is not supported for postgres indexing");
        return null;
    }

    public List<String> searchArchivableWorkflows(String indexName, long archiveTtlDays) {
        this.logger.info("searchArchivableWorkflows is not supported for postgres indexing");
        return null;
    }

    public long getWorkflowCount(String query, String freeText) {
        this.logger.info("getWorkflowCount is not supported for postgres indexing");
        return 0L;
    }
}

