/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.postgres.util;

import com.netflix.conductor.postgres.util.Query;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PostgresIndexQueryBuilder {
    private final String table;
    private final String freeText;
    private final int start;
    private final int count;
    private final List<String> sort;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private static final String[] VALID_FIELDS = new String[]{"workflow_id", "correlation_id", "workflow_type", "start_time", "status", "task_id", "task_type", "task_def_name", "update_time", "json_data", "to_tsvector(json_data::text)"};
    private static final String[] VALID_SORT_ORDER = new String[]{"ASC", "DESC"};

    public PostgresIndexQueryBuilder(String table, String query, String freeText, int start, int count, List<String> sort) {
        this.table = table;
        this.freeText = freeText;
        this.start = start;
        this.count = count;
        this.sort = sort;
        this.parseQuery(query);
        this.parseFreeText(freeText);
    }

    public String getQuery() {
        Object queryString = "";
        List validConditions = this.conditions.stream().filter(c -> c.isValid()).collect(Collectors.toList());
        if (validConditions.size() > 0) {
            queryString = " WHERE " + String.join((CharSequence)" AND ", validConditions.stream().map(c -> c.getQueryFragment()).collect(Collectors.toList()));
        }
        return "SELECT json_data::TEXT FROM " + this.table + (String)queryString + this.getSort() + " LIMIT ? OFFSET ?";
    }

    public void addParameters(Query q) throws SQLException {
        for (Condition condition : this.conditions) {
            condition.addParameter(q);
        }
        q.addParameter(this.count);
        q.addParameter(this.start);
    }

    private void parseQuery(String query) {
        if (!StringUtils.isEmpty((CharSequence)query)) {
            for (String s : query.split(" AND ")) {
                this.conditions.add(new Condition(s));
            }
            Collections.sort(this.conditions, Comparator.comparing(Condition::getQueryFragment));
        }
    }

    private void parseFreeText(String freeText) {
        if (!StringUtils.isEmpty((CharSequence)freeText) && !freeText.equals("*")) {
            if (freeText.startsWith("{") && freeText.endsWith("}")) {
                Condition cond = new Condition();
                cond.setAttribute("json_data");
                cond.setOperator("@>");
                String[] values = new String[]{freeText};
                cond.setValues(Arrays.asList(values));
                this.conditions.add(cond);
            } else {
                Condition cond = new Condition();
                cond.setAttribute("to_tsvector(json_data::text)");
                cond.setOperator("@@");
                String[] values = new String[]{freeText};
                cond.setValues(Arrays.asList(values));
                this.conditions.add(cond);
            }
        }
    }

    private String getSort() {
        ArrayList<CallSite> sortConds = new ArrayList<CallSite>();
        for (String s : this.sort) {
            String[] splitCond = s.split(":");
            if (splitCond.length != 2) continue;
            String attribute = PostgresIndexQueryBuilder.camelToSnake(splitCond[0]);
            String order = splitCond[1].toUpperCase();
            if (!Arrays.asList(VALID_FIELDS).contains(attribute) || !Arrays.asList(VALID_SORT_ORDER).contains(order)) continue;
            sortConds.add((CallSite)((Object)(attribute + " " + order)));
        }
        if (sortConds.size() > 0) {
            return " ORDER BY " + String.join((CharSequence)", ", sortConds);
        }
        return "";
    }

    private static String camelToSnake(String camel) {
        return camel.replaceAll("\\B([A-Z])", "_$1").toLowerCase();
    }

    private static class Condition {
        private String attribute;
        private String operator;
        private List<String> values;
        private final String CONDITION_REGEX = "([a-zA-Z]+)\\s?(=|>|<|IN)\\s?(.*)";

        public Condition() {
        }

        public Condition(String query) {
            Pattern conditionRegex = Pattern.compile("([a-zA-Z]+)\\s?(=|>|<|IN)\\s?(.*)");
            Matcher conditionMatcher = conditionRegex.matcher(query);
            if (conditionMatcher.find()) {
                String[] valueArr = conditionMatcher.group(3).replaceAll("[\"()]", "").split(",");
                ArrayList<String> values = new ArrayList<String>(Arrays.asList(valueArr));
                this.attribute = PostgresIndexQueryBuilder.camelToSnake(conditionMatcher.group(1));
                this.values = values;
                this.operator = this.getOperator(conditionMatcher.group(2));
                if (this.attribute.endsWith("_time")) {
                    values.set(0, this.millisToUtc(values.get(0)));
                }
            }
        }

        public String getQueryFragment() {
            if (this.operator.equals("IN")) {
                return this.attribute + " = ANY(?)";
            }
            if (this.operator.equals("@@")) {
                return this.attribute + " @@ to_tsquery(?)";
            }
            if (this.operator.equals("@>")) {
                return this.attribute + " @> ?::JSONB";
            }
            if (this.attribute.endsWith("_time")) {
                return this.attribute + " " + this.operator + " ?::TIMESTAMPTZ";
            }
            return this.attribute + " " + this.operator + " ?";
        }

        private String getOperator(String op) {
            if (op.equals("IN") && this.values.size() == 1) {
                return "=";
            }
            return op;
        }

        public void addParameter(Query q) throws SQLException {
            if (this.values.size() > 1) {
                q.addParameter(this.values);
            } else {
                q.addParameter(this.values.get(0));
            }
        }

        private String millisToUtc(String millis) {
            Long startTimeMilli = Long.parseLong(millis);
            ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTimeMilli), ZoneOffset.UTC);
            return DateTimeFormatter.ISO_DATE_TIME.format(startDate);
        }

        private boolean isValid() {
            return Arrays.asList(VALID_FIELDS).contains(this.attribute);
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }
    }
}

