/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.locking.redis.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.netflix.conductor.core.utils.Lock;
import com.netflix.conductor.locking.redis.RedisLock;
import com.netflix.conductor.locking.redis.config.RedisLockConfiguration;
import com.netflix.conductor.locking.redis.config.SystemPropertiesRedisLockConfiguration;
import java.util.Arrays;
import javax.inject.Singleton;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLockModule.class);

    protected void configure() {
        this.bind(RedisLockConfiguration.class).to(SystemPropertiesRedisLockConfiguration.class);
        this.bind(Lock.class).to(RedisLock.class).in(com.google.inject.Singleton.class);
    }

    @Provides
    @Singleton
    public Redisson getRedissonBasedOnConfig(RedisLockConfiguration clusterConfiguration) {
        RedisLockConfiguration.REDIS_SERVER_TYPE redisServerType;
        try {
            redisServerType = clusterConfiguration.getRedisServerType();
        }
        catch (IllegalArgumentException ie) {
            StringBuilder stringBuilder = new StringBuilder().append("Invalid Redis server type: ").append((Object)clusterConfiguration.getRedisServerType()).append(", supported values are: ");
            clusterConfiguration.getRedisServerType();
            String message = stringBuilder.append(Arrays.toString((Object[])RedisLockConfiguration.REDIS_SERVER_TYPE.values())).toString();
            LOGGER.error(message);
            throw new ProvisionException(message, (Throwable)ie);
        }
        String redisServerAddress = clusterConfiguration.getRedisServerAddress();
        Config redisConfig = new Config();
        int connectionTimeout = 10000;
        switch (redisServerType) {
            case SINGLE: {
                redisConfig.useSingleServer().setAddress(redisServerAddress).setTimeout(connectionTimeout);
                break;
            }
            case CLUSTER: {
                redisConfig.useClusterServers().setScanInterval(2000).addNodeAddress(redisServerAddress.split(",")).setTimeout(connectionTimeout);
                break;
            }
            case SENTINEL: {
                redisConfig.useSentinelServers().setScanInterval(2000).addSentinelAddress(new String[]{redisServerAddress}).setTimeout(connectionTimeout);
            }
        }
        return (Redisson)Redisson.create((Config)redisConfig);
    }
}

