/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redislock.config;

import com.netflix.conductor.core.sync.Lock;
import com.netflix.conductor.redislock.config.RedisLockProperties;
import com.netflix.conductor.redislock.lock.RedisLock;
import java.util.Arrays;
import org.redisson.Redisson;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RedisLockProperties.class})
@ConditionalOnProperty(name={"conductor.workflow-execution-lock.type"}, havingValue="redis")
public class RedisLockConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLockConfiguration.class);

    @Bean
    public Redisson getRedisson(RedisLockProperties properties) {
        RedisLockProperties.REDIS_SERVER_TYPE redisServerType;
        try {
            redisServerType = properties.getServerType();
        }
        catch (IllegalArgumentException ie) {
            String message = "Invalid Redis server type: " + properties.getServerType() + ", supported values are: " + Arrays.toString((Object[])RedisLockProperties.REDIS_SERVER_TYPE.values());
            LOGGER.error(message);
            throw new RuntimeException(message, ie);
        }
        String redisServerAddress = properties.getServerAddress();
        String redisServerPassword = properties.getServerPassword();
        String masterName = properties.getServerMasterName();
        Config redisConfig = new Config();
        int connectionTimeout = 10000;
        switch (redisServerType) {
            case SINGLE: {
                ((SingleServerConfig)redisConfig.useSingleServer().setAddress(redisServerAddress).setPassword(redisServerPassword)).setTimeout(connectionTimeout);
                break;
            }
            case CLUSTER: {
                ((ClusterServersConfig)redisConfig.useClusterServers().setScanInterval(2000).addNodeAddress(redisServerAddress.split(",")).setPassword(redisServerPassword)).setTimeout(connectionTimeout);
                break;
            }
            case SENTINEL: {
                ((SentinelServersConfig)redisConfig.useSentinelServers().setScanInterval(2000).setMasterName(masterName).addSentinelAddress(new String[]{redisServerAddress}).setPassword(redisServerPassword)).setTimeout(connectionTimeout);
            }
        }
        return (Redisson)Redisson.create((Config)redisConfig);
    }

    @Bean
    public Lock provideLock(Redisson redisson, RedisLockProperties properties) {
        return new RedisLock(redisson, properties);
    }
}

