/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.config;

import com.google.inject.ProvisionException;
import com.netflix.conductor.redis.config.AnyRedisCondition;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.dynoqueue.RedisQueuesShardingStrategyProvider;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import com.netflix.dyno.connectionpool.impl.lb.HostToken;
import com.netflix.dyno.connectionpool.impl.utils.CollectionUtils;
import com.netflix.dyno.queues.ShardSupplier;
import com.netflix.dyno.queues.redis.RedisQueues;
import com.netflix.dyno.queues.redis.sharding.ShardingStrategy;
import com.netflix.dyno.queues.shard.DynoShardSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.commands.JedisCommands;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class})
@Conditional(value={AnyRedisCondition.class})
public class RedisCommonConfiguration {
    public static final String DEFAULT_CLIENT_INJECTION_NAME = "DefaultJedisCommands";
    public static final String READ_CLIENT_INJECTION_NAME = "ReadJedisCommands";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCommonConfiguration.class);

    @Bean
    public ShardSupplier shardSupplier(HostSupplier hostSupplier, RedisProperties properties) {
        if (properties.getAvailabilityZone() == null) {
            throw new ProvisionException("Availability zone is not defined.  Ensure Configuration.getAvailabilityZone() returns a non-null and non-empty value.");
        }
        String localDC = properties.getAvailabilityZone().replaceAll(properties.getDataCenterRegion(), "");
        return new DynoShardSupplier(hostSupplier, properties.getDataCenterRegion(), localDC);
    }

    @Bean
    public TokenMapSupplier tokenMapSupplier() {
        final ArrayList hostTokens = new ArrayList();
        return new TokenMapSupplier(){

            public List<HostToken> getTokens(Set<Host> activeHosts) {
                long i = activeHosts.size();
                for (Host host : activeHosts) {
                    HostToken hostToken = new HostToken(Long.valueOf(i), host);
                    hostTokens.add(hostToken);
                    --i;
                }
                return hostTokens;
            }

            public HostToken getTokenForHost(Host host, Set<Host> activeHosts) {
                return (HostToken)CollectionUtils.find((Collection)hostTokens, token -> token.getHost().compareTo(host) == 0);
            }
        };
    }

    @Bean
    public ShardingStrategy shardingStrategy(ShardSupplier shardSupplier, RedisProperties properties) {
        return new RedisQueuesShardingStrategyProvider(shardSupplier, properties).get();
    }

    @Bean
    public RedisQueues redisQueues(@Qualifier(value="DefaultJedisCommands") JedisCommands jedisCommands, @Qualifier(value="ReadJedisCommands") JedisCommands jedisCommandsRead, ShardSupplier shardSupplier, RedisProperties properties, ShardingStrategy shardingStrategy) {
        RedisQueues queues = new RedisQueues(jedisCommands, jedisCommandsRead, properties.getQueuePrefix(), shardSupplier, 60000, 60000, shardingStrategy);
        LOGGER.info("DynoQueueDAO initialized with prefix " + properties.getQueuePrefix() + "!");
        return queues;
    }
}

