/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.netflix.conductor.common.validation.ErrorResponse;
import com.netflix.conductor.core.exception.ApplicationException;
import com.netflix.conductor.core.utils.Utils;
import com.netflix.conductor.metrics.Monitors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483647)
public class ApplicationExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationExceptionMapper.class);
    private final String host = Utils.getServerId();

    @ExceptionHandler(value={ApplicationException.class})
    public ResponseEntity<ErrorResponse> handleApplicationException(HttpServletRequest request, ApplicationException ex) {
        this.logException(request, (Throwable)ex);
        Monitors.error((String)"error", (String)String.valueOf(ex.getHttpStatusCode()));
        return new ResponseEntity((Object)this.toErrorResponse(ex), HttpStatus.valueOf((int)ex.getHttpStatusCode()));
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<ErrorResponse> handleAll(HttpServletRequest request, Throwable th) {
        this.logException(request, th);
        ApplicationException.Code code = th instanceof IllegalArgumentException || th instanceof InvalidFormatException ? ApplicationException.Code.INVALID_INPUT : ApplicationException.Code.INTERNAL_ERROR;
        ApplicationException ex = new ApplicationException(code, th.getMessage(), th);
        return this.handleApplicationException(request, ex);
    }

    private void logException(HttpServletRequest request, Throwable exception) {
        LOGGER.error(String.format("Error %s url: '%s'", exception.getClass().getSimpleName(), request.getRequestURI()), exception);
    }

    private ErrorResponse toErrorResponse(ApplicationException ex) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setInstance(this.host);
        errorResponse.setStatus(ex.getHttpStatusCode());
        errorResponse.setMessage(ex.getMessage());
        errorResponse.setRetryable(ex.isRetryable());
        return errorResponse;
    }
}

